/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An operand that is a JQL keyword. See [Advanced searching - keywords reference](https://confluence.atlassian.com/jiracorecloud/advanced-searching-keywords-reference-765593717.html#Advancedsearching-keywordsreference-EMPTYEMPTY) for more information about operand keywords.")
public class KeywordOperand {
    @JsonProperty(value="keyword")
    private KeywordEnum keyword;

    public KeywordOperand keyword(KeywordEnum keyword) {
        this.keyword = keyword;
        return this;
    }

    @ApiModelProperty(required=true, value="The keyword that is the operand value.")
    public KeywordEnum getKeyword() {
        return this.keyword;
    }

    public void setKeyword(KeywordEnum keyword) {
        this.keyword = keyword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordOperand keywordOperand = (KeywordOperand)o;
        return Objects.equals((Object)this.keyword, (Object)keywordOperand.keyword);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyword});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeywordOperand {\n");
        sb.append("    keyword: ").append(this.toIndentedString((Object)this.keyword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KeywordEnum {
        EMPTY("empty");

        private String value;

        private KeywordEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeywordEnum fromValue(String value) {
            for (KeywordEnum b : KeywordEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

