/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. Not all issues returned by the JQL query will be loaded, but only a portion of them, as described by the `startAt` and `maxResults` properties. Iterate over pages by inspecting the meta data included in the response.")
public class JexpJqlIssues {
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="startAt")
    private Long startAt;
    @JsonProperty(value="maxResults")
    private Integer maxResults;
    @JsonProperty(value="validation")
    private ValidationEnum validation = ValidationEnum.STRICT;

    public JexpJqlIssues query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="The JQL query.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public JexpJqlIssues startAt(Long startAt) {
        this.startAt = startAt;
        return this;
    }

    @ApiModelProperty(value="The index of the first issue returned from the JQL query.")
    public Long getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    public JexpJqlIssues maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @ApiModelProperty(value="The maximum number of issues that will be included on the list. This value is currently capped at 1000 but the cap may change without notice.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public JexpJqlIssues validation(ValidationEnum validation) {
        this.validation = validation;
        return this;
    }

    @ApiModelProperty(value="Determines how to validate the JQL query and treat the validation results.")
    public ValidationEnum getValidation() {
        return this.validation;
    }

    public void setValidation(ValidationEnum validation) {
        this.validation = validation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JexpJqlIssues jexpJqlIssues = (JexpJqlIssues)o;
        return Objects.equals(this.query, jexpJqlIssues.query) && Objects.equals(this.startAt, jexpJqlIssues.startAt) && Objects.equals(this.maxResults, jexpJqlIssues.maxResults) && Objects.equals((Object)this.validation, (Object)jexpJqlIssues.validation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.startAt, this.maxResults, this.validation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JexpJqlIssues {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    validation: ").append(this.toIndentedString((Object)this.validation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ValidationEnum {
        STRICT("strict"),
        WARN("warn"),
        NONE("none");

        private String value;

        private ValidationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValidationEnum fromValue(String value) {
            for (ValidationEnum b : ValidationEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

