/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The description of the page of issues loaded by the provided JQL query.")
public class IssuesJqlMetaDataBean {
    @JsonProperty(value="startAt")
    private Long startAt;
    @JsonProperty(value="maxResults")
    private Integer maxResults;
    @JsonProperty(value="count")
    private Integer count;
    @JsonProperty(value="totalCount")
    private Long totalCount;
    @JsonProperty(value="validationWarnings")
    private List<String> validationWarnings = new ArrayList<String>();

    public IssuesJqlMetaDataBean startAt(Long startAt) {
        this.startAt = startAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The index of the first issue.")
    public Long getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    public IssuesJqlMetaDataBean maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum number of issues that could be loaded in this evaluation.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public IssuesJqlMetaDataBean count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of issues that were loaded in this evaluation.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public IssuesJqlMetaDataBean totalCount(Long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of issues the JQL returned.")
    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public IssuesJqlMetaDataBean validationWarnings(List<String> validationWarnings) {
        this.validationWarnings = validationWarnings;
        return this;
    }

    public IssuesJqlMetaDataBean addValidationWarningsItem(String validationWarningsItem) {
        if (this.validationWarnings == null) {
            this.validationWarnings = new ArrayList<String>();
        }
        this.validationWarnings.add(validationWarningsItem);
        return this;
    }

    @ApiModelProperty(value="Any warnings related to the JQL query. Present only if the validation mode was set to `warn`.")
    public List<String> getValidationWarnings() {
        return this.validationWarnings;
    }

    public void setValidationWarnings(List<String> validationWarnings) {
        this.validationWarnings = validationWarnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssuesJqlMetaDataBean issuesJqlMetaDataBean = (IssuesJqlMetaDataBean)o;
        return Objects.equals(this.startAt, issuesJqlMetaDataBean.startAt) && Objects.equals(this.maxResults, issuesJqlMetaDataBean.maxResults) && Objects.equals(this.count, issuesJqlMetaDataBean.count) && Objects.equals(this.totalCount, issuesJqlMetaDataBean.totalCount) && Objects.equals(this.validationWarnings, issuesJqlMetaDataBean.validationWarnings);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.maxResults, this.count, this.totalCount, this.validationWarnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssuesJqlMetaDataBean {\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    validationWarnings: ").append(this.toIndentedString(this.validationWarnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

