/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v2.model.FieldMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.Scope;

@ApiModel(description="Details of the issue creation metadata for an issue type.")
public class IssueTypeIssueCreateMetadata {
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="iconUrl")
    private String iconUrl;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="subtask")
    private Boolean subtask;
    @JsonProperty(value="avatarId")
    private Long avatarId;
    @JsonProperty(value="entityId")
    private UUID entityId;
    @JsonProperty(value="scope")
    private Scope scope;
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="fields")
    private Map<String, FieldMetadata> fields = new HashMap<String, FieldMetadata>();

    @ApiModelProperty(value="The URL of these issue type details.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The ID of the issue type.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The description of the issue type.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The URL of the issue type's avatar.")
    public String getIconUrl() {
        return this.iconUrl;
    }

    @ApiModelProperty(value="The name of the issue type.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="Indicates whether this issue type is used to create subtasks.")
    public Boolean getSubtask() {
        return this.subtask;
    }

    @ApiModelProperty(value="The ID of the issue type's avatar.")
    public Long getAvatarId() {
        return this.avatarId;
    }

    @ApiModelProperty(value="project unique ID for next-gen entities")
    public UUID getEntityId() {
        return this.entityId;
    }

    @ApiModelProperty(value="Details of the next-gen projects the issue type is available in.")
    public Scope getScope() {
        return this.scope;
    }

    @ApiModelProperty(value="Expand options that include additional issue type metadata details in the response.")
    public String getExpand() {
        return this.expand;
    }

    @ApiModelProperty(value="List of the fields available when creating an issue for the issue type.")
    public Map<String, FieldMetadata> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeIssueCreateMetadata issueTypeIssueCreateMetadata = (IssueTypeIssueCreateMetadata)o;
        return Objects.equals(this.self, issueTypeIssueCreateMetadata.self) && Objects.equals(this.id, issueTypeIssueCreateMetadata.id) && Objects.equals(this.description, issueTypeIssueCreateMetadata.description) && Objects.equals(this.iconUrl, issueTypeIssueCreateMetadata.iconUrl) && Objects.equals(this.name, issueTypeIssueCreateMetadata.name) && Objects.equals(this.subtask, issueTypeIssueCreateMetadata.subtask) && Objects.equals(this.avatarId, issueTypeIssueCreateMetadata.avatarId) && Objects.equals(this.entityId, issueTypeIssueCreateMetadata.entityId) && Objects.equals(this.scope, issueTypeIssueCreateMetadata.scope) && Objects.equals(this.expand, issueTypeIssueCreateMetadata.expand) && Objects.equals(this.fields, issueTypeIssueCreateMetadata.fields);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.id, this.description, this.iconUrl, this.name, this.subtask, this.avatarId, this.entityId, this.scope, this.expand, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeIssueCreateMetadata {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subtask: ").append(this.toIndentedString(this.subtask)).append("\n");
        sb.append("    avatarId: ").append(this.toIndentedString(this.avatarId)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

