/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.FieldMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusDetails;

@ApiModel(description="Details of an issue transition.")
public class IssueTransition {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="to")
    private StatusDetails to;
    @JsonProperty(value="hasScreen")
    private Boolean hasScreen;
    @JsonProperty(value="isGlobal")
    private Boolean isGlobal;
    @JsonProperty(value="isInitial")
    private Boolean isInitial;
    @JsonProperty(value="isConditional")
    private Boolean isConditional;
    @JsonProperty(value="fields")
    private Map<String, FieldMetadata> fields = new HashMap<String, FieldMetadata>();
    @JsonProperty(value="expand")
    private String expand;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public IssueTransition id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue transition. Required when specifying a transition to undertake.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The name of the issue transition.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="Details of the issue status after the transition.")
    public StatusDetails getTo() {
        return this.to;
    }

    @ApiModelProperty(value="Indicates whether there is a screen associated with the issue transition.")
    public Boolean getHasScreen() {
        return this.hasScreen;
    }

    @ApiModelProperty(value="Indicates whether the issue transition is global, that is, the transition is applied to issues regardless of their status.")
    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    @ApiModelProperty(value="Indicates whether this is the initial issue transition for the workflow.")
    public Boolean getIsInitial() {
        return this.isInitial;
    }

    @ApiModelProperty(value="Indicates whether the issue has to meet certain criteria before the issue transition is applied.")
    public Boolean getIsConditional() {
        return this.isConditional;
    }

    @ApiModelProperty(value="Details of the fields associated with the issue transition screen. Use this information to populate `fields` and `update` in a transition request.")
    public Map<String, FieldMetadata> getFields() {
        return this.fields;
    }

    @ApiModelProperty(value="Expand options that include additional transition details in the response.")
    public String getExpand() {
        return this.expand;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTransition issueTransition = (IssueTransition)o;
        return Objects.equals(this.id, issueTransition.id) && Objects.equals(this.name, issueTransition.name) && Objects.equals(this.to, issueTransition.to) && Objects.equals(this.hasScreen, issueTransition.hasScreen) && Objects.equals(this.isGlobal, issueTransition.isGlobal) && Objects.equals(this.isInitial, issueTransition.isInitial) && Objects.equals(this.isConditional, issueTransition.isConditional) && Objects.equals(this.fields, issueTransition.fields) && Objects.equals(this.expand, issueTransition.expand) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.to, this.hasScreen, this.isGlobal, this.isInitial, this.isConditional, this.fields, this.expand, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTransition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    hasScreen: ").append(this.toIndentedString(this.hasScreen)).append("\n");
        sb.append("    isGlobal: ").append(this.toIndentedString(this.isGlobal)).append("\n");
        sb.append("    isInitial: ").append(this.toIndentedString(this.isInitial)).append("\n");
        sb.append("    isConditional: ").append(this.toIndentedString(this.isConditional)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

