/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v2.model.Application;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteObject;

/**
 * Details of a remote issue link.
 */
@ApiModel(description = "Details of a remote issue link.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-09-05T12:17:30.184+02:00[Europe/Prague]")
public class RemoteIssueLinkRequest {
  @JsonProperty("globalId")
  private String globalId;

  @JsonProperty("application")
  private Application application;

  @JsonProperty("relationship")
  private String relationship;

  @JsonProperty("object")
  private RemoteObject _object;

  private HashMap<String, Object> additionalProperties_ = new HashMap<String, Object>();

  public RemoteIssueLinkRequest globalId(String globalId) {
    this.globalId = globalId;
    return this;
  }

   /**
   * An identifier for the remote item in the remote system. For example, the global ID for a remote item in Confluence would consist of the app ID and page ID, like this: &#x60;appId&#x3D;456&amp;pageId&#x3D;123&#x60;.  Setting this field enables the remote issue link details to be updated or deleted using remote system and item details as the record identifier, rather than using the record&#39;s Jira ID.  The maximum length is 255 characters.
   * @return globalId
  **/
  @ApiModelProperty(value = "An identifier for the remote item in the remote system. For example, the global ID for a remote item in Confluence would consist of the app ID and page ID, like this: `appId=456&pageId=123`.  Setting this field enables the remote issue link details to be updated or deleted using remote system and item details as the record identifier, rather than using the record's Jira ID.  The maximum length is 255 characters.")
  public String getGlobalId() {
    return globalId;
  }

  public void setGlobalId(String globalId) {
    this.globalId = globalId;
  }

  public RemoteIssueLinkRequest application(Application application) {
    this.application = application;
    return this;
  }

   /**
   * Details of the remote application the linked item is in. For example, trello.
   * @return application
  **/
  @ApiModelProperty(value = "Details of the remote application the linked item is in. For example, trello.")
  public Application getApplication() {
    return application;
  }

  public void setApplication(Application application) {
    this.application = application;
  }

  public RemoteIssueLinkRequest relationship(String relationship) {
    this.relationship = relationship;
    return this;
  }

   /**
   * Description of the relationship between the issue and the linked item. If not set, the relationship description \&quot;links to\&quot; is used in Jira.
   * @return relationship
  **/
  @ApiModelProperty(value = "Description of the relationship between the issue and the linked item. If not set, the relationship description \"links to\" is used in Jira.")
  public String getRelationship() {
    return relationship;
  }

  public void setRelationship(String relationship) {
    this.relationship = relationship;
  }

  public RemoteIssueLinkRequest _object(RemoteObject _object) {
    this._object = _object;
    return this;
  }

   /**
   * Details of the item linked to.
   * @return _object
  **/
  @ApiModelProperty(value = "Details of the item linked to.")
  public RemoteObject getObject() {
    return _object;
  }

  public void setObject(RemoteObject _object) {
    this._object = _object;
  }


  @com.fasterxml.jackson.annotation.JsonAnyGetter
  public Map<String, Object> any() {
   return this.additionalProperties_;
  }

  @com.fasterxml.jackson.annotation.JsonAnySetter
  public void set(String name, Object value) {
   this.additionalProperties_.put(name, value);
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RemoteIssueLinkRequest remoteIssueLinkRequest = (RemoteIssueLinkRequest) o;
    return Objects.equals(this.globalId, remoteIssueLinkRequest.globalId) &&
        Objects.equals(this.application, remoteIssueLinkRequest.application) &&
        Objects.equals(this.relationship, remoteIssueLinkRequest.relationship) &&
        Objects.equals(this._object, remoteIssueLinkRequest._object) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(globalId, application, relationship, _object, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RemoteIssueLinkRequest {\n");
    
    sb.append("    globalId: ").append(toIndentedString(globalId)).append("\n");
    sb.append("    application: ").append(toIndentedString(application)).append("\n");
    sb.append("    relationship: ").append(toIndentedString(relationship)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties_)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

