/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowId;

@ApiModel(description="Details of any errors encountered while updating workflow transition rules for a workflow.")
public class WorkflowTransitionRulesUpdateErrorDetails {
    @JsonProperty(value="workflowId")
    private WorkflowId workflowId;
    @JsonProperty(value="ruleUpdateErrors")
    private Map<String, List<String>> ruleUpdateErrors = new HashMap<String, List<String>>();
    @JsonProperty(value="updateErrors")
    private List<String> updateErrors = new ArrayList<String>();

    public WorkflowTransitionRulesUpdateErrorDetails workflowId(WorkflowId workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowId getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(WorkflowId workflowId) {
        this.workflowId = workflowId;
    }

    public WorkflowTransitionRulesUpdateErrorDetails ruleUpdateErrors(Map<String, List<String>> ruleUpdateErrors) {
        this.ruleUpdateErrors = ruleUpdateErrors;
        return this;
    }

    public WorkflowTransitionRulesUpdateErrorDetails putRuleUpdateErrorsItem(String key, List<String> ruleUpdateErrorsItem) {
        this.ruleUpdateErrors.put(key, ruleUpdateErrorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of transition rule update errors, indexed by the transition rule ID. Any transition rule that appears here wasn't updated.")
    public Map<String, List<String>> getRuleUpdateErrors() {
        return this.ruleUpdateErrors;
    }

    public void setRuleUpdateErrors(Map<String, List<String>> ruleUpdateErrors) {
        this.ruleUpdateErrors = ruleUpdateErrors;
    }

    public WorkflowTransitionRulesUpdateErrorDetails updateErrors(List<String> updateErrors) {
        this.updateErrors = updateErrors;
        return this;
    }

    public WorkflowTransitionRulesUpdateErrorDetails addUpdateErrorsItem(String updateErrorsItem) {
        if (this.updateErrors == null) {
            this.updateErrors = new ArrayList<String>();
        }
        this.updateErrors.add(updateErrorsItem);
        return this;
    }

    @ApiModelProperty(value="The list of errors that specify why the workflow update failed. The workflow was not updated if the list contains any entries.")
    public List<String> getUpdateErrors() {
        return this.updateErrors;
    }

    public void setUpdateErrors(List<String> updateErrors) {
        this.updateErrors = updateErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTransitionRulesUpdateErrorDetails workflowTransitionRulesUpdateErrorDetails = (WorkflowTransitionRulesUpdateErrorDetails)o;
        return Objects.equals(this.workflowId, workflowTransitionRulesUpdateErrorDetails.workflowId) && Objects.equals(this.ruleUpdateErrors, workflowTransitionRulesUpdateErrorDetails.ruleUpdateErrors) && Objects.equals(this.updateErrors, workflowTransitionRulesUpdateErrorDetails.updateErrors);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.ruleUpdateErrors, this.updateErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowTransitionRulesUpdateErrorDetails {\n");
        sb.append("    workflowId: ").append(this.toIndentedString(this.workflowId)).append("\n");
        sb.append("    ruleUpdateErrors: ").append(this.toIndentedString(this.ruleUpdateErrors)).append("\n");
        sb.append("    updateErrors: ").append(this.toIndentedString(this.updateErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

