/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A webhook.")
public class Webhook {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="jqlFilter")
    private String jqlFilter;
    @JsonProperty(value="events")
    private List<EventsEnum> events = new ArrayList<EventsEnum>();
    @JsonProperty(value="expirationDate")
    private Long expirationDate;

    public Webhook id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the webhook.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Webhook jqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
        return this;
    }

    @ApiModelProperty(required=true, value="The JQL filter that specifies which issues the webhook is sent for.")
    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public void setJqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
    }

    public Webhook events(List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public Webhook addEventsItem(EventsEnum eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<EventsEnum>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="The Jira events that trigger the webhook.")
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventsEnum> events) {
        this.events = events;
    }

    @ApiModelProperty(required=true, value="")
    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.id, webhook.id) && Objects.equals(this.jqlFilter, webhook.jqlFilter) && Objects.equals(this.events, webhook.events) && Objects.equals(this.expirationDate, webhook.expirationDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jqlFilter, this.events, this.expirationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    jqlFilter: ").append(this.toIndentedString(this.jqlFilter)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventsEnum {
        JIRA_ISSUE_CREATED("jira:issue_created"),
        JIRA_ISSUE_UPDATED("jira:issue_updated"),
        JIRA_ISSUE_DELETED("jira:issue_deleted"),
        COMMENT_CREATED("comment_created"),
        COMMENT_UPDATED("comment_updated"),
        COMMENT_DELETED("comment_deleted");

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventsEnum fromValue(String value) {
            for (EventsEnum b : EventsEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

