/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details of a permission and its availability to a user.")
public class UserPermission {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="havePermission")
    private Boolean havePermission;
    @JsonProperty(value="deprecatedKey")
    private Boolean deprecatedKey;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public UserPermission id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserPermission key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The key of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UserPermission name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the permission.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserPermission type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the permission.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UserPermission description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the permission.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UserPermission havePermission(Boolean havePermission) {
        this.havePermission = havePermission;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the permission is available to the user in the queried context.")
    public Boolean getHavePermission() {
        return this.havePermission;
    }

    public void setHavePermission(Boolean havePermission) {
        this.havePermission = havePermission;
    }

    public UserPermission deprecatedKey(Boolean deprecatedKey) {
        this.deprecatedKey = deprecatedKey;
        return this;
    }

    @ApiModelProperty(value="Indicate whether the permission key is deprecated. Note that deprecated keys cannot be used in the `permissions parameter of Get my permissions. Deprecated keys are not returned by Get all permissions.`")
    public Boolean getDeprecatedKey() {
        return this.deprecatedKey;
    }

    public void setDeprecatedKey(Boolean deprecatedKey) {
        this.deprecatedKey = deprecatedKey;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPermission userPermission = (UserPermission)o;
        return Objects.equals(this.id, userPermission.id) && Objects.equals(this.key, userPermission.key) && Objects.equals(this.name, userPermission.name) && Objects.equals((Object)this.type, (Object)userPermission.type) && Objects.equals(this.description, userPermission.description) && Objects.equals(this.havePermission, userPermission.havePermission) && Objects.equals(this.deprecatedKey, userPermission.deprecatedKey) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.name, this.type, this.description, this.havePermission, this.deprecatedKey, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPermission {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    havePermission: ").append(this.toIndentedString(this.havePermission)).append("\n");
        sb.append("    deprecatedKey: ").append(this.toIndentedString(this.deprecatedKey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GLOBAL("GLOBAL"),
        PROJECT("PROJECT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

