/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.Dashboard;

@ApiModel(description="A page containing dashboard details.")
public class PageOfDashboards {
    @JsonProperty(value="startAt")
    private Integer startAt;
    @JsonProperty(value="maxResults")
    private Integer maxResults;
    @JsonProperty(value="total")
    private Integer total;
    @JsonProperty(value="prev")
    private String prev;
    @JsonProperty(value="next")
    private String next;
    @JsonProperty(value="dashboards")
    private List<Dashboard> dashboards = new ArrayList<Dashboard>();

    @ApiModelProperty(value="The index of the first item returned on the page.")
    public Integer getStartAt() {
        return this.startAt;
    }

    @ApiModelProperty(value="The maximum number of results that could be on the page.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @ApiModelProperty(value="The number of results on the page.")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="The URL of the previous page of results, if any.")
    public String getPrev() {
        return this.prev;
    }

    @ApiModelProperty(value="The URL of the next page of results, if any.")
    public String getNext() {
        return this.next;
    }

    @ApiModelProperty(value="List of dashboards.")
    public List<Dashboard> getDashboards() {
        return this.dashboards;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageOfDashboards pageOfDashboards = (PageOfDashboards)o;
        return Objects.equals(this.startAt, pageOfDashboards.startAt) && Objects.equals(this.maxResults, pageOfDashboards.maxResults) && Objects.equals(this.total, pageOfDashboards.total) && Objects.equals(this.prev, pageOfDashboards.prev) && Objects.equals(this.next, pageOfDashboards.next) && Objects.equals(this.dashboards, pageOfDashboards.dashboards);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.maxResults, this.total, this.prev, this.next, this.dashboards);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageOfDashboards {\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    prev: ").append(this.toIndentedString(this.prev)).append("\n");
        sb.append("    next: ").append(this.toIndentedString(this.next)).append("\n");
        sb.append("    dashboards: ").append(this.toIndentedString(this.dashboards)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

