/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryClauseOperand;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryField;

@ApiModel(description="A clause that asserts the current value of a field. For example, `summary ~ test`.")
public class FieldValueClause {
    @JsonProperty(value="field")
    private JqlQueryField field;
    @JsonProperty(value="operator")
    private OperatorEnum operator;
    @JsonProperty(value="operand")
    private JqlQueryClauseOperand operand;

    public FieldValueClause field(JqlQueryField field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JqlQueryField getField() {
        return this.field;
    }

    public void setField(JqlQueryField field) {
        this.field = field;
    }

    public FieldValueClause operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="The operator between the field and operand.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public FieldValueClause operand(JqlQueryClauseOperand operand) {
        this.operand = operand;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JqlQueryClauseOperand getOperand() {
        return this.operand;
    }

    public void setOperand(JqlQueryClauseOperand operand) {
        this.operand = operand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValueClause fieldValueClause = (FieldValueClause)o;
        return Objects.equals(this.field, fieldValueClause.field) && Objects.equals((Object)this.operator, (Object)fieldValueClause.operator) && Objects.equals(this.operand, fieldValueClause.operand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.operator, this.operand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldValueClause {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    operand: ").append(this.toIndentedString(this.operand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        EQUAL("="),
        NOT_EQUAL("!="),
        GREATER_THAN(">"),
        LESS_THAN("<"),
        GREATER_THAN_OR_EQUAL_TO(">="),
        LESS_THAN_OR_EQUAL_TO("<="),
        IN("in"),
        NOT_IN("not in"),
        _("~="),
        IS("is"),
        IS_NOT("is not");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

