/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A JQL query clause that consists of nested clauses. For example, `(labels in (urgent, blocker) OR lastCommentedBy = currentUser()). Note that, where nesting is not defined, the parser nests JQL clauses based on the operator precedence. For example, \"A OR B AND C\" is parsed as \"(A OR B) AND C\". See Setting the precedence of operators for more information about precedence in JQL queries.`")
public class CompoundClause {
    @JsonProperty(value="clauses")
    private List<Object> clauses = new ArrayList<Object>();
    @JsonProperty(value="operator")
    private OperatorEnum operator;

    public CompoundClause clauses(List<Object> clauses) {
        this.clauses = clauses;
        return this;
    }

    public CompoundClause addClausesItem(Object clausesItem) {
        this.clauses.add(clausesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of nested clauses.")
    public List<Object> getClauses() {
        return this.clauses;
    }

    public void setClauses(List<Object> clauses) {
        this.clauses = clauses;
    }

    public CompoundClause operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="The operator between the clauses.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundClause compoundClause = (CompoundClause)o;
        return Objects.equals(this.clauses, compoundClause.clauses) && Objects.equals((Object)this.operator, (Object)compoundClause.operator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clauses, this.operator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompoundClause {\n");
        sb.append("    clauses: ").append(this.toIndentedString(this.clauses)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        AND("and"),
        OR("or"),
        NOT("not");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

