/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A list of webhooks.")
public class WebhookDetails {
    @JsonProperty(value="jqlFilter")
    private String jqlFilter;
    @JsonProperty(value="events")
    private List<EventsEnum> events = new ArrayList<EventsEnum>();

    public WebhookDetails jqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
        return this;
    }

    @ApiModelProperty(required=true, value="The JQL filter that specifies which issues the webhook is sent for. Only a subset of JQL can be used. The supported elements are:   *  Fields: `issueKey`, `project`, `issuetype`, `status`, `assignee`, `reporter`, `issue.property`, and `cf[id]` (for custom fields\u2014only the epic label custom field is supported).  *  Operators: `=`, `!=`, `IN`, and `NOT IN`.")
    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public void setJqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
    }

    public WebhookDetails events(List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public WebhookDetails addEventsItem(EventsEnum eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<EventsEnum>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="The Jira events that trigger the webhook.")
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventsEnum> events) {
        this.events = events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookDetails webhookDetails = (WebhookDetails)o;
        return Objects.equals(this.jqlFilter, webhookDetails.jqlFilter) && Objects.equals(this.events, webhookDetails.events);
    }

    public int hashCode() {
        return Objects.hash(this.jqlFilter, this.events);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookDetails {\n");
        sb.append("    jqlFilter: ").append(this.toIndentedString(this.jqlFilter)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventsEnum {
        JIRA_ISSUE_CREATED("jira:issue_created"),
        JIRA_ISSUE_UPDATED("jira:issue_updated"),
        JIRA_ISSUE_DELETED("jira:issue_deleted"),
        COMMENT_CREATED("comment_created"),
        COMMENT_UPDATED("comment_updated"),
        COMMENT_DELETED("comment_deleted");

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventsEnum fromValue(String value) {
            for (EventsEnum b : EventsEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

