/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenID;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowRules;

@ApiModel(description="Details of a workflow transition.")
public class Transition {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="from")
    private List<String> from = new ArrayList<String>();
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="screen")
    private ScreenID screen;
    @JsonProperty(value="rules")
    private WorkflowRules rules;

    public Transition id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the transition.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Transition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the transition.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Transition description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the transition.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Transition from(List<String> from) {
        this.from = from;
        return this;
    }

    public Transition addFromItem(String fromItem) {
        this.from.add(fromItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of statuses from which the transition can be taken.")
    public List<String> getFrom() {
        return this.from;
    }

    public void setFrom(List<String> from) {
        this.from = from;
    }

    public Transition to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(required=true, value="The status to which the transition leads.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Transition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the transition.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Transition screen(ScreenID screen) {
        this.screen = screen;
        return this;
    }

    @ApiModelProperty(value="")
    public ScreenID getScreen() {
        return this.screen;
    }

    public void setScreen(ScreenID screen) {
        this.screen = screen;
    }

    public Transition rules(WorkflowRules rules) {
        this.rules = rules;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowRules getRules() {
        return this.rules;
    }

    public void setRules(WorkflowRules rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transition transition = (Transition)o;
        return Objects.equals(this.id, transition.id) && Objects.equals(this.name, transition.name) && Objects.equals(this.description, transition.description) && Objects.equals(this.from, transition.from) && Objects.equals(this.to, transition.to) && Objects.equals((Object)this.type, (Object)transition.type) && Objects.equals(this.screen, transition.screen) && Objects.equals(this.rules, transition.rules);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.from, this.to, this.type, this.screen, this.rules});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    screen: ").append(this.toIndentedString(this.screen)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GLOBAL("global"),
        INITIAL("initial"),
        DIRECTED("directed");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

