/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class CustomFieldDefinitionJsonBean {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="searcherKey")
    private SearcherKeyEnum searcherKey;

    public CustomFieldDefinitionJsonBean name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the custom field, which is displayed in Jira. This is not the unique identifier.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomFieldDefinitionJsonBean description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the custom field, which is displayed in Jira.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CustomFieldDefinitionJsonBean type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the custom field. For example, *com.atlassian.jira.plugin.system.customfieldtypes:grouppicker*.   *  `cascadingselect`: Allows multiple values to be selected using two select lists  *  `datepicker`: Stores a date using a picker control  *  `datetime`: Stores a date with a time component  *  `float`: Stores and validates a numeric (floating point) input  *  `grouppicker`: Stores a user group using a picker control  *  `importid`: A read-only field that stores the previous ID of the issue from the system that it was imported from  *  `labels`: Stores labels  *  `multicheckboxes`: Stores multiple values using checkboxes  *  `multigrouppicker`: Stores multiple user groups using a picker control  *  `multiselect`: Stores multiple values using a select list  *  `multiuserpicker`: Stores multiple users using a picker control  *  `multiversion`: Stores multiple versions from the versions available in a project using a picker control  *  `project`: Stores a project from a list of projects that the user is permitted to view  *  `radiobuttons`: Stores a value using radio buttons  *  `readonlyfield`: Stores a read-only text value, which can only be populated via the API  *  `select`: Stores a value from a configurable list of options  *  `textarea`: Stores a long text string using a multiline text area  *  `textfield`: Stores a text string using a single-line text box  *  `url`: Stores a URL  *  `userpicker`: Stores a user using a picker control  *  `version`: Stores a version using a picker control")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CustomFieldDefinitionJsonBean searcherKey(SearcherKeyEnum searcherKey) {
        this.searcherKey = searcherKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The searcher defines the way the field is searched in Jira. For example, *com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher*.   The search UI (basic search and JQL search) will display different operations and values for the field, based on the field searcher. You must specify a searcher that is valid for the field type, as listed below (abbreviated values shown):   *  `cascadingselect`: `cascadingselectsearcher`  *  `datepicker`: `daterange`  *  `datetime`: `datetimerange`  *  `float`: `exactnumber` or `numberrange`  *  `grouppicker`: `grouppickersearcher`  *  `importid`: `exactnumber` or `numberrange`  *  `labels`: `labelsearcher`  *  `multicheckboxes`: `multiselectsearcher`  *  `multigrouppicker`: `multiselectsearcher`  *  `multiselect`: `multiselectsearcher`  *  `multiuserpicker`: `userpickergroupsearcher`  *  `multiversion`: `versionsearcher`  *  `project`: `projectsearcher`  *  `radiobuttons`: `multiselectsearcher`  *  `readonlyfield`: `textsearcher`  *  `select`: `multiselectsearcher`  *  `textarea`: `textsearcher`  *  `textfield`: `textsearcher`  *  `url`: `exacttextsearcher`  *  `userpicker`: `userpickergroupsearcher`  *  `version`: `versionsearcher`")
    public SearcherKeyEnum getSearcherKey() {
        return this.searcherKey;
    }

    public void setSearcherKey(SearcherKeyEnum searcherKey) {
        this.searcherKey = searcherKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldDefinitionJsonBean customFieldDefinitionJsonBean = (CustomFieldDefinitionJsonBean)o;
        return Objects.equals(this.name, customFieldDefinitionJsonBean.name) && Objects.equals(this.description, customFieldDefinitionJsonBean.description) && Objects.equals((Object)this.type, (Object)customFieldDefinitionJsonBean.type) && Objects.equals((Object)this.searcherKey, (Object)customFieldDefinitionJsonBean.searcherKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.type, this.searcherKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomFieldDefinitionJsonBean {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    searcherKey: ").append(this.toIndentedString((Object)this.searcherKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SearcherKeyEnum {
        CASCADINGSELECTSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher"),
        DATERANGE("com.atlassian.jira.plugin.system.customfieldtypes:daterange"),
        DATETIMERANGE("com.atlassian.jira.plugin.system.customfieldtypes:datetimerange"),
        EXACTNUMBER("com.atlassian.jira.plugin.system.customfieldtypes:exactnumber"),
        EXACTTEXTSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher"),
        GROUPPICKERSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher"),
        LABELSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher"),
        MULTISELECTSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher"),
        NUMBERRANGE("com.atlassian.jira.plugin.system.customfieldtypes:numberrange"),
        PROJECTSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher"),
        TEXTSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:textsearcher"),
        USERPICKERGROUPSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher"),
        VERSIONSEARCHER("com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher");

        private String value;

        private SearcherKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SearcherKeyEnum fromValue(String value) {
            for (SearcherKeyEnum b : SearcherKeyEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        CASCADINGSELECT("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect"),
        DATEPICKER("com.atlassian.jira.plugin.system.customfieldtypes:datepicker"),
        DATETIME("com.atlassian.jira.plugin.system.customfieldtypes:datetime"),
        FLOAT("com.atlassian.jira.plugin.system.customfieldtypes:float"),
        GROUPPICKER("com.atlassian.jira.plugin.system.customfieldtypes:grouppicker"),
        IMPORTID("com.atlassian.jira.plugin.system.customfieldtypes:importid"),
        LABELS("com.atlassian.jira.plugin.system.customfieldtypes:labels"),
        MULTICHECKBOXES("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes"),
        MULTIGROUPPICKER("com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker"),
        MULTISELECT("com.atlassian.jira.plugin.system.customfieldtypes:multiselect"),
        MULTIUSERPICKER("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker"),
        MULTIVERSION("com.atlassian.jira.plugin.system.customfieldtypes:multiversion"),
        PROJECT("com.atlassian.jira.plugin.system.customfieldtypes:project"),
        RADIOBUTTONS("com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons"),
        READONLYFIELD("com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield"),
        SELECT("com.atlassian.jira.plugin.system.customfieldtypes:select"),
        TEXTAREA("com.atlassian.jira.plugin.system.customfieldtypes:textarea"),
        TEXTFIELD("com.atlassian.jira.plugin.system.customfieldtypes:textfield"),
        URL("com.atlassian.jira.plugin.system.customfieldtypes:url"),
        USERPICKER("com.atlassian.jira.plugin.system.customfieldtypes:userpicker"),
        VERSION("com.atlassian.jira.plugin.system.customfieldtypes:version");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

