/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.AddFieldBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.MoveFieldBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanScreen;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenableField;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenableTab;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ScreensApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<Object> returnType_addFieldToDefaultScreen = new TypeReference<Object>(){};
    private static final TypeReference<ScreenableTab> returnType_addScreenTab = new TypeReference<ScreenableTab>(){};
    private static final TypeReference<ScreenableField> returnType_addScreenTabField = new TypeReference<ScreenableField>(){};
    private static final TypeReference<List<ScreenableField>> returnType_getAllScreenTabFields = new TypeReference<List<ScreenableField>>(){};
    private static final TypeReference<List<ScreenableTab>> returnType_getAllScreenTabs = new TypeReference<List<ScreenableTab>>(){};
    private static final TypeReference<PageBeanScreen> returnType_getAllScreens = new TypeReference<PageBeanScreen>(){};
    private static final TypeReference<List<ScreenableField>> returnType_getAvailableScreenFields = new TypeReference<List<ScreenableField>>(){};
    private static final TypeReference<Object> returnType_moveScreenTab = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_moveScreenTabField = new TypeReference<Object>(){};
    private static final TypeReference<ScreenableTab> returnType_renameScreenTab = new TypeReference<ScreenableTab>(){};
    private final RestClient restClient;

    public ScreensApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addFieldToDefaultScreen(String fieldId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/addToDefault/{fieldId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addFieldToDefaultScreen);
    }

    public Single<ScreenableTab> addScreenTab(Long screenId, ScreenableTab screenableTab, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(screenableTab));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addScreenTab);
    }

    public Single<ScreenableField> addScreenTabField(Long screenId, Long tabId, AddFieldBean addFieldBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(addFieldBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addScreenTabField);
    }

    public Completable deleteScreenTab(Long screenId, Long tabId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<List<ScreenableField>> getAllScreenTabFields(Long screenId, Long tabId, Optional<String> projectKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllScreenTabFields);
    }

    public Single<List<ScreenableTab>> getAllScreenTabs(Long screenId, Optional<String> projectKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllScreenTabs);
    }

    public Single<PageBeanScreen> getAllScreens(Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllScreens);
    }

    public Single<List<ScreenableField>> getAvailableScreenFields(Long screenId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/availableFields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAvailableScreenFields);
    }

    public Single<Object> moveScreenTab(Long screenId, Long tabId, Integer pos, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/move/{pos}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        pathParams.put("pos", String.valueOf(pos));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_moveScreenTab);
    }

    public Single<Object> moveScreenTabField(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}/move");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(moveFieldBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_moveScreenTabField);
    }

    public Completable removeScreenTabField(Long screenId, Long tabId, String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<ScreenableTab> renameScreenTab(Long screenId, Long tabId, ScreenableTab screenableTab, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(screenableTab));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_renameScreenTab);
    }
}

