/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.resource.AbstractUserTemplateResource;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;
import org.eurekaclinical.useragreement.client.comm.UserAgreementUserTemplate;
import org.eurekaclinical.useragreement.service.entity.AuthorizedRoleEntity;
import org.eurekaclinical.useragreement.service.entity.UserTemplateEntity;

@Path(value="/protected/usertemplates")
@Transactional
public class UserTemplateResource
extends AbstractUserTemplateResource<UserAgreementUserTemplate, AuthorizedRoleEntity, UserTemplateEntity> {
    private final RoleDao<AuthorizedRoleEntity> roleDao;

    @Inject
    public UserTemplateResource(UserTemplateDao<AuthorizedRoleEntity, UserTemplateEntity> inUserDao, RoleDao<AuthorizedRoleEntity> inRoleDao) {
        super(inUserDao);
        this.roleDao = inRoleDao;
    }

    protected UserAgreementUserTemplate toComm(UserTemplateEntity templateEntity, HttpServletRequest req) {
        UserAgreementUserTemplate template = new UserAgreementUserTemplate();
        template.setId(templateEntity.getId());
        template.setName(templateEntity.getName());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (AuthorizedRoleEntity roleEntity : templateEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        template.setRoles(roles);
        template.setAutoAuthorize(templateEntity.isAutoAuthorize());
        template.setCriteria(templateEntity.getCriteria());
        return template;
    }

    protected UserTemplateEntity toEntity(UserAgreementUserTemplate template) {
        UserTemplateEntity templateEntity = new UserTemplateEntity();
        templateEntity.setId(template.getId());
        templateEntity.setName(template.getName());
        List roleEntities = this.roleDao.getAll();
        for (Long roleId : template.getRoles()) {
            for (AuthorizedRoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                templateEntity.addRole(roleEntity);
            }
        }
        templateEntity.setAutoAuthorize(template.isAutoAuthorize());
        templateEntity.setCriteria(template.getCriteria());
        return templateEntity;
    }
}

