/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.util.UserSupport;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.useragreement.client.comm.Status;
import org.eurekaclinical.useragreement.client.comm.UserAgreementStatus;
import org.eurekaclinical.useragreement.service.dao.UserAgreementDao;
import org.eurekaclinical.useragreement.service.dao.UserAgreementStatusDao;
import org.eurekaclinical.useragreement.service.entity.UserAgreementEntity;
import org.eurekaclinical.useragreement.service.entity.UserAgreementStatusEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/protected/useragreementstatuses")
@Consumes(value={"application/json"})
@Transactional
public class UserAgreementStatusResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgreementStatusResource.class);
    private final UserAgreementStatusDao userAgreementStatusDao;
    private final UserSupport userSupport;
    private final UserAgreementDao userAgreementDao;

    @Inject
    public UserAgreementStatusResource(UserAgreementStatusDao inUserAgreementStatusDao, UserAgreementDao inUserAgreementDao) {
        this.userAgreementStatusDao = inUserAgreementStatusDao;
        this.userAgreementDao = inUserAgreementDao;
        this.userSupport = new UserSupport();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    public List<UserAgreementStatus> getAll() {
        List uaes = this.userAgreementStatusDao.getAll();
        ArrayList<UserAgreementStatus> result = new ArrayList<UserAgreementStatus>(uaes.size());
        for (UserAgreementStatusEntity uae : uaes) {
            UserAgreementStatus status = new UserAgreementStatus();
            status.setId(uae.getId());
            status.setUsername(uae.getUsername());
            status.setExpiry(uae.getExpiry());
            status.setFullname(uae.getFullname());
            status.setStatus(uae.getState());
            status.setUserAgreement(uae.getUserAgreement().getId());
            result.add(status);
        }
        return result;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public UserAgreementStatus getById(@PathParam(value="id") Long inId, @Context HttpServletRequest req) {
        UserAgreementStatusEntity uae = (UserAgreementStatusEntity)this.userAgreementStatusDao.retrieve((Object)inId);
        if (uae == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        String username = uae.getUsername();
        this.checkUsername(username, req, Response.Status.FORBIDDEN);
        UserAgreementStatus status = new UserAgreementStatus();
        status.setId(uae.getId());
        status.setUsername(uae.getUsername());
        status.setExpiry(uae.getExpiry());
        status.setFullname(uae.getFullname());
        status.setStatus(uae.getState());
        status.setUserAgreement(uae.getUserAgreement().getId());
        return status;
    }

    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    public UserAgreementStatus getMine(@QueryParam(value="status") Status status, @Context HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        String username = principal.getName();
        UserAgreementStatusEntity uae = this.userAgreementStatusDao.getByUsername(username);
        if (uae == null || status != null && status != uae.getState()) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        UserAgreementStatus uas = new UserAgreementStatus();
        uas.setId(uae.getId());
        uas.setUsername(uae.getUsername());
        uas.setExpiry(uae.getExpiry());
        uas.setFullname(uae.getFullname());
        uas.setStatus(uae.getState());
        uas.setUserAgreement(uae.getUserAgreement().getId());
        return uas;
    }

    @POST
    public Response create(UserAgreementStatus inUserAgreement, @Context HttpServletRequest req) {
        String username = inUserAgreement.getUsername();
        if (!req.getRemoteUser().equals(username)) {
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        UserAgreementStatusEntity userAgreementEntity = this.userAgreementStatusDao.getByUsername(username);
        if (userAgreementEntity == null) {
            userAgreementEntity = new UserAgreementStatusEntity();
            userAgreementEntity.setUsername(username);
        }
        userAgreementEntity.setFullname(inUserAgreement.getFullname());
        Calendar now = Calendar.getInstance();
        now.add(1, 1);
        userAgreementEntity.setExpiry(now.getTime());
        UserAgreementEntity uae = (UserAgreementEntity)this.userAgreementDao.retrieve((Object)inUserAgreement.getUserAgreement());
        if (uae == null) {
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        userAgreementEntity.setUserAgreement(uae);
        this.userAgreementStatusDao.create((Object)userAgreementEntity);
        return Response.created((URI)URI.create("/" + userAgreementEntity.getId())).build();
    }

    private void checkUsername(String username, HttpServletRequest req, Response.Status status) {
        if (!req.isUserInRole("admin") && !this.userSupport.isSameUser(req, username)) {
            throw new HttpStatusException(status);
        }
    }
}

