/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.eurekaclinical.useragreement.service.entity.AuthorizedRoleEntity;

@Table(name="usertemplates")
@Entity
public class UserTemplateEntity
implements org.eurekaclinical.standardapis.entity.UserTemplateEntity<AuthorizedRoleEntity> {
    @Id
    @SequenceGenerator(name="UT_SEQ_GENERATOR", sequenceName="UT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="UT_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String name;
    private boolean autoAuthorize;
    private String criteria;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="usertemplate_role", joinColumns={@JoinColumn(name="usertemplate_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<AuthorizedRoleEntity> roles = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutoAuthorize() {
        return this.autoAuthorize;
    }

    public void setAutoAuthorize(boolean autoAuthorize) {
        this.autoAuthorize = autoAuthorize;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    public List<AuthorizedRoleEntity> getRoles() {
        return new ArrayList<AuthorizedRoleEntity>(this.roles);
    }

    public void setRoles(List<AuthorizedRoleEntity> inRoles) {
        this.roles = inRoles == null ? new ArrayList() : new ArrayList<AuthorizedRoleEntity>(inRoles);
    }

    public void addRole(AuthorizedRoleEntity role) {
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
    }

    public void removeRole(AuthorizedRoleEntity role) {
        this.roles.remove(role);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTemplateEntity other = (UserTemplateEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "UserTemplateEntity{id=" + this.id + ", name=" + this.name + ", autoAuthorize=" + this.autoAuthorize + ", criteria=" + this.criteria + ", roles=" + this.roles + '}';
    }
}

