/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.entity;

import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eurekaclinical.useragreement.client.comm.Status;
import org.eurekaclinical.useragreement.service.entity.UserAgreementEntity;

@Entity
@Table(name="user_agreement_statuses")
public class UserAgreementStatusEntity {
    @Id
    @SequenceGenerator(name="USER_AGR_STAT_SEQ_GENERATOR", sequenceName="USER_AGR_STAT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_AGR_STAT_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String username;
    @Column(nullable=false)
    private String fullname;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expiry;
    @ManyToOne
    @JoinColumn(nullable=false)
    private UserAgreementEntity userAgreement;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry;
    }

    public UserAgreementEntity getUserAgreement() {
        return this.userAgreement;
    }

    public void setUserAgreement(UserAgreementEntity userAgreement) {
        this.userAgreement = userAgreement;
    }

    public boolean isExpired() {
        Date now = new Date();
        return !now.before(this.expiry);
    }

    public boolean isActive() {
        return !this.isExpired();
    }

    public Status getState() {
        if (this.isExpired()) {
            return Status.EXPIRED;
        }
        return Status.ACTIVE;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgreementStatusEntity other = (UserAgreementStatusEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "UserAgreementStatusEntity{id=" + this.id + ", username=" + this.username + ", fullname=" + this.fullname + ", expiry=" + this.expiry + ", userAgreement=" + this.userAgreement + '}';
    }
}

