/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.eurekaclinical.standardapis.entity.AbstractUserEntity;
import org.eurekaclinical.useragreement.service.entity.AuthorizedRoleEntity;

@Entity
@Table(name="users")
public class AuthorizedUserEntity
extends AbstractUserEntity<AuthorizedRoleEntity> {
    @Id
    @SequenceGenerator(name="USER_SEQ_GENERATOR", sequenceName="USER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String username;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<AuthorizedRoleEntity> roles = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String inUsername) {
        this.username = inUsername;
    }

    public List<AuthorizedRoleEntity> getRoles() {
        return new ArrayList<AuthorizedRoleEntity>(this.roles);
    }

    public void setRoles(List<AuthorizedRoleEntity> inRoles) {
        this.roles = inRoles == null ? new ArrayList() : new ArrayList<AuthorizedRoleEntity>(inRoles);
    }

    public void addRole(AuthorizedRoleEntity inRole) {
        this.roles.add(inRole);
    }

    public void removeRole(AuthorizedRoleEntity inRole) {
        this.roles.remove(inRole);
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizedUserEntity other = (AuthorizedUserEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "UserEntity{id=" + this.id + ", username=" + this.username + ", roles=" + this.roles + '}';
    }
}

