/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreementservice.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.util.UserSupport;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.useragreementcommon.comm.UserAgreementStatus;
import org.eurekaclinical.useragreementservice.dao.UserAgreementDao;
import org.eurekaclinical.useragreementservice.dao.UserAgreementStatusDao;
import org.eurekaclinical.useragreementservice.entity.UserAgreementEntity;
import org.eurekaclinical.useragreementservice.entity.UserAgreementStatusEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/protected/useragreementstatuses")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Transactional
public class UserAgreementStatusResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgreementStatusResource.class);
    private final UserAgreementStatusDao userAgreementStatusDao;
    private final UserSupport userSupport;
    private final UserAgreementDao userAgreementDao;

    @Inject
    public UserAgreementStatusResource(UserAgreementStatusDao inUserAgreementStatusDao, UserAgreementDao inUserAgreementDao) {
        this.userAgreementStatusDao = inUserAgreementStatusDao;
        this.userAgreementDao = inUserAgreementDao;
        this.userSupport = new UserSupport();
    }

    @GET
    @RolesAllowed(value={"admin"})
    public List<UserAgreementStatus> getAll() {
        List uaes = this.userAgreementStatusDao.getAll();
        ArrayList<UserAgreementStatus> result = new ArrayList<UserAgreementStatus>(uaes.size());
        for (UserAgreementStatusEntity uae : uaes) {
            UserAgreementStatus status = new UserAgreementStatus();
            status.setId(uae.getId());
            status.setUsername(uae.getUsername());
            status.setExpiry(uae.getExpiry());
            status.setFullname(uae.getFullname());
            status.setStatus(uae.getState());
            status.setUserAgreement(uae.getUserAgreement().getId());
            result.add(status);
        }
        return result;
    }

    @Path(value="/{id}")
    @GET
    public UserAgreementStatus getById(@PathParam(value="id") Long inId, @Context HttpServletRequest req) {
        UserAgreementStatusEntity uae = (UserAgreementStatusEntity)this.userAgreementStatusDao.retrieve((Object)inId);
        if (uae == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        String username = uae.getUsername();
        this.checkUsername(username, req, Response.Status.FORBIDDEN);
        UserAgreementStatus status = new UserAgreementStatus();
        status.setId(uae.getId());
        status.setUsername(uae.getUsername());
        status.setExpiry(uae.getExpiry());
        status.setFullname(uae.getFullname());
        status.setStatus(uae.getState());
        status.setUserAgreement(uae.getUserAgreement().getId());
        return status;
    }

    @Path(value="/me")
    @GET
    public UserAgreementStatus getMine(@Context HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        String username = principal.getName();
        UserAgreementStatusEntity uae = this.userAgreementStatusDao.getByUsername(username);
        if (uae == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        UserAgreementStatus status = new UserAgreementStatus();
        status.setId(uae.getId());
        status.setUsername(uae.getUsername());
        status.setExpiry(uae.getExpiry());
        status.setFullname(uae.getFullname());
        status.setStatus(uae.getState());
        status.setUserAgreement(uae.getUserAgreement().getId());
        return status;
    }

    @POST
    public Response create(UserAgreementStatus inUserAgreement, @Context HttpServletRequest req) {
        String username = inUserAgreement.getUsername();
        if (!req.getRemoteUser().equals(username)) {
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        UserAgreementStatusEntity userAgreementEntity = this.userAgreementStatusDao.getByUsername(username);
        if (userAgreementEntity == null) {
            userAgreementEntity = new UserAgreementStatusEntity();
            userAgreementEntity.setUsername(username);
        }
        userAgreementEntity.setFullname(inUserAgreement.getFullname());
        Calendar now = Calendar.getInstance();
        now.add(1, 1);
        userAgreementEntity.setExpiry(now.getTime());
        UserAgreementEntity uae = (UserAgreementEntity)this.userAgreementDao.retrieve((Object)inUserAgreement.getUserAgreement());
        if (uae == null) {
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        userAgreementEntity.setUserAgreement(uae);
        this.userAgreementStatusDao.create((Object)userAgreementEntity);
        return Response.created((URI)URI.create("/" + userAgreementEntity.getId())).build();
    }

    private void checkUsername(String username, HttpServletRequest req, Response.Status status) {
        if (!req.isUserInRole("admin") && !this.userSupport.isSameUser(req, username)) {
            throw new HttpStatusException(status);
        }
    }
}

