/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreementservice.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.useragreementcommon.comm.UserAgreement;
import org.eurekaclinical.useragreementservice.dao.UserAgreementDao;
import org.eurekaclinical.useragreementservice.entity.UserAgreementEntity;

@Path(value="/protected/useragreements")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Transactional
public class UserAgreementResource {
    private final UserAgreementDao userAgreementDao;

    @Inject
    public UserAgreementResource(UserAgreementDao inUserAgreementDao) {
        this.userAgreementDao = inUserAgreementDao;
    }

    @GET
    public List<UserAgreement> getAll() {
        ArrayList<UserAgreement> results = new ArrayList<UserAgreement>();
        for (UserAgreementEntity uae : this.userAgreementDao.getAll()) {
            results.add(uae.toUserAgreement());
        }
        return results;
    }

    @GET
    @Path(value="/current")
    public UserAgreement getCurrent() {
        UserAgreementEntity uae = this.userAgreementDao.getCurrent();
        if (uae == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return uae.toUserAgreement();
    }

    @GET
    @Path(value="/{id}")
    public UserAgreement getAny(@PathParam(value="id") Long inId, @Context HttpServletRequest req) {
        UserAgreementEntity uae = (UserAgreementEntity)this.userAgreementDao.retrieve((Object)inId);
        if (uae == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return uae.toUserAgreement();
    }

    @RolesAllowed(value={"admin"})
    @POST
    public Response create(UserAgreement userAgreement) {
        UserAgreementEntity uae = this.userAgreementDao.createOrUpdate(userAgreement.getText());
        return Response.created((URI)URI.create("/" + uae.getId())).build();
    }
}

