/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.EtlNodeToServicesNodeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eurekaclinical.eureka.client.comm.Cohort;
import org.eurekaclinical.eureka.client.comm.CohortDestination;
import org.eurekaclinical.eureka.client.comm.CovidOmopDestination;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.eurekaclinical.eureka.client.comm.I2B2Destination;
import org.eurekaclinical.eureka.client.comm.Neo4jDestination;
import org.eurekaclinical.eureka.client.comm.NodeVisitor;
import org.eurekaclinical.eureka.client.comm.OmopDestination;
import org.eurekaclinical.eureka.client.comm.PatientListDestination;
import org.eurekaclinical.eureka.client.comm.PatientSetExtractorDestination;
import org.eurekaclinical.eureka.client.comm.PatientSetSenderDestination;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.PhenotypeSearchDestination;
import org.eurekaclinical.eureka.client.comm.TableColumn;
import org.eurekaclinical.eureka.client.comm.TabularFileDestination;
import org.eurekaclinical.protempa.client.comm.AbstractEtlDestinationVisitor;
import org.eurekaclinical.protempa.client.comm.EtlCohortDestination;
import org.eurekaclinical.protempa.client.comm.EtlCovidOmopDestination;
import org.eurekaclinical.protempa.client.comm.EtlDestination;
import org.eurekaclinical.protempa.client.comm.EtlI2B2Destination;
import org.eurekaclinical.protempa.client.comm.EtlNeo4jDestination;
import org.eurekaclinical.protempa.client.comm.EtlOmopDestination;
import org.eurekaclinical.protempa.client.comm.EtlPatientListDestination;
import org.eurekaclinical.protempa.client.comm.EtlPatientSetExtractorDestination;
import org.eurekaclinical.protempa.client.comm.EtlPatientSetSenderDestination;
import org.eurekaclinical.protempa.client.comm.EtlPhenotypeSearchDestination;
import org.eurekaclinical.protempa.client.comm.EtlTableColumn;
import org.eurekaclinical.protempa.client.comm.EtlTabularFileDestination;

public class EtlDestinationToDestinationVisitor
extends AbstractEtlDestinationVisitor {
    private Destination destination;
    private final ConversionSupport conversionSupport;

    public EtlDestinationToDestinationVisitor(ConversionSupport conversionSupport) {
        this.conversionSupport = conversionSupport;
    }

    public void visit(EtlCohortDestination etlCohortDestination) {
        CohortDestination cohortDestination = new CohortDestination();
        this.visitCommon((EtlDestination)etlCohortDestination, (Destination)cohortDestination);
        EtlNodeToServicesNodeVisitor v = new EtlNodeToServicesNodeVisitor();
        Cohort etlCohort = etlCohortDestination.getCohort();
        Cohort servicesCohort = new Cohort();
        etlCohort.getNode().accept((NodeVisitor)v);
        servicesCohort.setNode(v.getNode());
        cohortDestination.setCohort(servicesCohort);
        this.destination = cohortDestination;
    }

    public void visit(EtlI2B2Destination etlI2B2Destination) {
        I2B2Destination i2b2Destination = new I2B2Destination();
        this.visitCommon((EtlDestination)etlI2B2Destination, (Destination)i2b2Destination);
        this.destination = i2b2Destination;
    }

    public void visit(EtlNeo4jDestination etlNeo4jDestination) {
        Neo4jDestination neo4jDestination = new Neo4jDestination();
        this.visitCommon((EtlDestination)etlNeo4jDestination, (Destination)neo4jDestination);
        neo4jDestination.setDbPath(etlNeo4jDestination.getDbPath());
        this.destination = neo4jDestination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    private void visitCommon(EtlDestination etlDestination, Destination destination) {
        destination.setId(etlDestination.getId());
        destination.setName(etlDestination.getName());
        destination.setDescription(etlDestination.getDescription());
        PhenotypeField[] etlDestPhenotypeFields = etlDestination.getPhenotypeFields();
        if (etlDestPhenotypeFields != null) {
            destination.setPhenotypeFields(etlDestPhenotypeFields);
        }
        destination.setOwnerUserId(etlDestination.getOwnerUserId());
        destination.setRead(etlDestination.isRead());
        destination.setWrite(etlDestination.isWrite());
        destination.setExecute(etlDestination.isExecute());
        destination.setCreatedAt(etlDestination.getCreatedAt());
        destination.setUpdatedAt(etlDestination.getUpdatedAt());
        destination.setLinks(etlDestination.getLinks());
        destination.setGetStatisticsSupported(etlDestination.isGetStatisticsSupported());
        destination.setJobConceptListSupported(etlDestination.isAllowingQueryPropositionIds());
        List requiredPropIds = etlDestination.getRequiredPropositionIds();
        ArrayList<String> requiredConcepts = new ArrayList<String>(requiredPropIds != null ? requiredPropIds.size() : 0);
        if (requiredPropIds != null) {
            for (String requiredPropId : requiredPropIds) {
                if (requiredPropId == null) continue;
                requiredConcepts.add(this.conversionSupport.toPhenotypeKey(requiredPropId));
            }
        }
        destination.setRequiredConcepts(requiredConcepts);
    }

    public void visit(EtlPatientSetExtractorDestination etlPatientSetExtractorDestination) {
        PatientSetExtractorDestination ptSetExtractorDest = new PatientSetExtractorDestination();
        this.visitCommon((EtlDestination)etlPatientSetExtractorDestination, (Destination)ptSetExtractorDest);
        ptSetExtractorDest.setAliasPropositionId(etlPatientSetExtractorDestination.getAliasPropositionId());
        ptSetExtractorDest.setAliasFieldName(etlPatientSetExtractorDestination.getAliasFieldName());
        ptSetExtractorDest.setAliasFieldNameProperty(etlPatientSetExtractorDestination.getAliasFieldNameProperty());
        ptSetExtractorDest.setAliasPatientIdProperty(etlPatientSetExtractorDestination.getAliasPatientIdProperty());
        this.destination = ptSetExtractorDest;
    }

    public void visit(EtlPatientSetSenderDestination etlPatientSetSenderDestination) {
        PatientSetSenderDestination ptSetExtractorDest = new PatientSetSenderDestination();
        this.visitCommon((EtlDestination)etlPatientSetSenderDestination, (Destination)ptSetExtractorDest);
        ptSetExtractorDest.setAliasPropositionId(etlPatientSetSenderDestination.getAliasPropositionId());
        ptSetExtractorDest.setAliasFieldName(etlPatientSetSenderDestination.getAliasFieldName());
        ptSetExtractorDest.setAliasFieldNameProperty(etlPatientSetSenderDestination.getAliasFieldNameProperty());
        ptSetExtractorDest.setAliasPatientIdProperty(etlPatientSetSenderDestination.getAliasPatientIdProperty());
        ptSetExtractorDest.setPatientSetService(etlPatientSetSenderDestination.getPatientSetService());
        this.destination = ptSetExtractorDest;
    }

    public void visit(EtlTabularFileDestination etlTabularFileDestination) {
        TabularFileDestination tabularFileDest = new TabularFileDestination();
        this.visitCommon((EtlDestination)etlTabularFileDestination, (Destination)tabularFileDest);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (EtlTableColumn etlTableColumn : etlTabularFileDestination.getTableColumns()) {
            TableColumn tableColumn = new TableColumn();
            tableColumn.setTableName(etlTableColumn.getTableName());
            tableColumn.setColumnName(etlTableColumn.getColumnName());
            tableColumn.setPath(etlTableColumn.getPath());
            tableColumn.setFormat(etlTableColumn.getFormat());
            tableColumns.add(tableColumn);
        }
        tabularFileDest.setTableColumns(tableColumns);
        this.destination = tabularFileDest;
    }

    public void visit(EtlPatientListDestination etlPatientListDestination) {
        PatientListDestination result = new PatientListDestination();
        this.visitCommon((EtlDestination)etlPatientListDestination, (Destination)result);
        this.destination = result;
    }

    public void visit(EtlOmopDestination etlOmopDestination) {
        OmopDestination omopDest = new OmopDestination();
        this.visitCommon((EtlDestination)etlOmopDestination, (Destination)omopDest);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (EtlTableColumn etlTableColumn : etlOmopDestination.getTableColumns()) {
            TableColumn tableColumn = new TableColumn();
            tableColumn.setTableName(etlTableColumn.getTableName());
            tableColumn.setColumnName(etlTableColumn.getColumnName());
            tableColumn.setPath(etlTableColumn.getPath());
            tableColumn.setFormat(etlTableColumn.getFormat());
            tableColumns.add(tableColumn);
        }
        omopDest.setTableColumns(tableColumns);
        this.destination = omopDest;
    }

    public void visit(EtlCovidOmopDestination etlCovidOmopDestination) {
        CovidOmopDestination covidOmopDest = new CovidOmopDestination();
        this.visitCommon((EtlDestination)etlCovidOmopDestination, (Destination)covidOmopDest);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (EtlTableColumn etlTableColumn : etlCovidOmopDestination.getTableColumns()) {
            TableColumn tableColumn = new TableColumn();
            tableColumn.setTableName(etlTableColumn.getTableName());
            tableColumn.setColumnName(etlTableColumn.getColumnName());
            tableColumn.setPath(etlTableColumn.getPath());
            tableColumn.setFormat(etlTableColumn.getFormat());
            tableColumns.add(tableColumn);
        }
        covidOmopDest.setTableColumns(tableColumns);
        this.destination = covidOmopDest;
    }

    public void visit(EtlPhenotypeSearchDestination etlPhenotypeSearchDestination) {
        PhenotypeSearchDestination phenotypeSearchDestination = new PhenotypeSearchDestination();
        this.visitCommon((EtlDestination)etlPhenotypeSearchDestination, (Destination)phenotypeSearchDestination);
        this.destination = phenotypeSearchDestination;
    }
}

