/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ServicesNodeToEtlNodeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eurekaclinical.eureka.client.comm.AbstractDestinationVisitor;
import org.eurekaclinical.eureka.client.comm.Cohort;
import org.eurekaclinical.eureka.client.comm.CohortDestination;
import org.eurekaclinical.eureka.client.comm.CovidOmopDestination;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.eurekaclinical.eureka.client.comm.I2B2Destination;
import org.eurekaclinical.eureka.client.comm.Neo4jDestination;
import org.eurekaclinical.eureka.client.comm.NodeVisitor;
import org.eurekaclinical.eureka.client.comm.OmopDestination;
import org.eurekaclinical.eureka.client.comm.PatientListDestination;
import org.eurekaclinical.eureka.client.comm.PatientSetExtractorDestination;
import org.eurekaclinical.eureka.client.comm.PatientSetSenderDestination;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.PhenotypeSearchDestination;
import org.eurekaclinical.eureka.client.comm.RelDbDestination;
import org.eurekaclinical.eureka.client.comm.TableColumn;
import org.eurekaclinical.eureka.client.comm.TabularFileDestination;
import org.eurekaclinical.protempa.client.comm.EtlCohortDestination;
import org.eurekaclinical.protempa.client.comm.EtlCovidOmopDestination;
import org.eurekaclinical.protempa.client.comm.EtlDestination;
import org.eurekaclinical.protempa.client.comm.EtlI2B2Destination;
import org.eurekaclinical.protempa.client.comm.EtlNeo4jDestination;
import org.eurekaclinical.protempa.client.comm.EtlOmopDestination;
import org.eurekaclinical.protempa.client.comm.EtlPatientListDestination;
import org.eurekaclinical.protempa.client.comm.EtlPatientSetExtractorDestination;
import org.eurekaclinical.protempa.client.comm.EtlPatientSetSenderDestination;
import org.eurekaclinical.protempa.client.comm.EtlPhenotypeSearchDestination;
import org.eurekaclinical.protempa.client.comm.EtlTableColumn;
import org.eurekaclinical.protempa.client.comm.EtlTabularFileDestination;

public class DestinationToEtlDestinationVisitor
extends AbstractDestinationVisitor {
    private EtlDestination etlDestination;
    private final ConversionSupport conversionSupport;

    public DestinationToEtlDestinationVisitor(ConversionSupport inConversionSupport) {
        this.conversionSupport = inConversionSupport;
    }

    public void visit(CohortDestination cohortDestination) {
        EtlCohortDestination etlCohortDestination = new EtlCohortDestination();
        this.visitCommon((Destination)cohortDestination, (EtlDestination)etlCohortDestination);
        ServicesNodeToEtlNodeVisitor v = new ServicesNodeToEtlNodeVisitor();
        Cohort servicesCohort = cohortDestination.getCohort();
        Cohort etlCohort = new Cohort();
        servicesCohort.getNode().accept((NodeVisitor)v);
        etlCohort.setNode(v.getNode());
        etlCohortDestination.setCohort(etlCohort);
        this.etlDestination = etlCohortDestination;
    }

    public void visit(I2B2Destination i2b2Destination) {
        EtlI2B2Destination etlI2B2Destination = new EtlI2B2Destination();
        this.visitCommon((Destination)i2b2Destination, (EtlDestination)etlI2B2Destination);
        this.etlDestination = etlI2B2Destination;
    }

    public void visit(Neo4jDestination neo4jDestination) {
        EtlNeo4jDestination etlNeo4jDestination = new EtlNeo4jDestination();
        this.visitCommon((Destination)neo4jDestination, (EtlDestination)etlNeo4jDestination);
        etlNeo4jDestination.setDbPath(neo4jDestination.getDbPath());
        this.etlDestination = etlNeo4jDestination;
    }

    public EtlDestination getEtlDestination() {
        return this.etlDestination;
    }

    private void visitCommon(Destination destination, EtlDestination etlDestination) {
        etlDestination.setId(destination.getId());
        etlDestination.setName(destination.getName());
        etlDestination.setDescription(destination.getDescription());
        PhenotypeField[] etlDestPhenotypeFields = destination.getPhenotypeFields();
        if (etlDestPhenotypeFields != null) {
            etlDestination.setPhenotypeFields(etlDestPhenotypeFields);
        }
        etlDestination.setOwnerUserId(destination.getOwnerUserId());
        etlDestination.setRead(destination.isRead());
        etlDestination.setWrite(destination.isWrite());
        etlDestination.setExecute(destination.isExecute());
        etlDestination.setLinks(destination.getLinks());
        etlDestination.setGetStatisticsSupported(destination.isGetStatisticsSupported());
        List requiredConcepts = destination.getRequiredConcepts();
        if (requiredConcepts != null) {
            ArrayList<String> requiredPropIds = new ArrayList<String>(requiredConcepts.size());
            for (String requiredConcept : requiredConcepts) {
                requiredPropIds.add(this.conversionSupport.toPropositionId(requiredConcept));
            }
            etlDestination.setRequiredPropositionIds(requiredPropIds);
        }
        etlDestination.setAllowingQueryPropositionIds(destination.isJobConceptListSupported());
    }

    public void visit(PatientSetExtractorDestination patientSetExtractorDestination) {
        EtlPatientSetExtractorDestination etlPtSetExtractorDest = new EtlPatientSetExtractorDestination();
        etlPtSetExtractorDest.setAliasPropositionId(patientSetExtractorDestination.getAliasPropositionId());
        etlPtSetExtractorDest.setAliasFieldName(patientSetExtractorDestination.getAliasFieldName());
        etlPtSetExtractorDest.setAliasFieldNameProperty(patientSetExtractorDestination.getAliasFieldNameProperty());
        etlPtSetExtractorDest.setAliasPatientIdProperty(patientSetExtractorDestination.getAliasPatientIdProperty());
        this.visitCommon((Destination)patientSetExtractorDestination, (EtlDestination)etlPtSetExtractorDest);
        this.etlDestination = etlPtSetExtractorDest;
    }

    public void visit(PatientSetSenderDestination patientSetSenderDestination) {
        EtlPatientSetSenderDestination etlPtSetSenderDest = new EtlPatientSetSenderDestination();
        etlPtSetSenderDest.setAliasPropositionId(patientSetSenderDestination.getAliasPropositionId());
        etlPtSetSenderDest.setAliasFieldName(patientSetSenderDestination.getAliasFieldName());
        etlPtSetSenderDest.setAliasFieldNameProperty(patientSetSenderDestination.getAliasFieldNameProperty());
        etlPtSetSenderDest.setAliasPatientIdProperty(patientSetSenderDestination.getAliasPatientIdProperty());
        etlPtSetSenderDest.setPatientSetService(patientSetSenderDestination.getPatientSetService());
        this.visitCommon((Destination)patientSetSenderDestination, (EtlDestination)etlPtSetSenderDest);
        this.etlDestination = etlPtSetSenderDest;
    }

    public void visit(TabularFileDestination tabularFileDestination) {
        EtlTabularFileDestination etlTabularFileDest = new EtlTabularFileDestination();
        ArrayList<EtlTableColumn> etlTableColumns = new ArrayList<EtlTableColumn>();
        for (TableColumn tableColumn : tabularFileDestination.getTableColumns()) {
            EtlTableColumn etlTableColumn = new EtlTableColumn();
            etlTableColumn.setTableName(tableColumn.getTableName());
            etlTableColumn.setColumnName(tableColumn.getColumnName());
            etlTableColumn.setPath(tableColumn.getPath());
            etlTableColumn.setFormat(tableColumn.getFormat());
            etlTableColumns.add(etlTableColumn);
        }
        etlTabularFileDest.setTableColumns(etlTableColumns);
        this.visitCommon((Destination)tabularFileDestination, (EtlDestination)etlTabularFileDest);
        this.etlDestination = etlTabularFileDest;
    }

    public void visit(RelDbDestination relDbDestination) {
    }

    public void visit(PatientListDestination patientListDestination) {
        EtlPatientListDestination result = new EtlPatientListDestination();
        this.visitCommon((Destination)patientListDestination, (EtlDestination)result);
        this.etlDestination = result;
    }

    public void visit(OmopDestination omopDestination) {
        EtlOmopDestination etlOmopDest = new EtlOmopDestination();
        ArrayList<EtlTableColumn> etlTableColumns = new ArrayList<EtlTableColumn>();
        for (EtlTableColumn tableColumn : etlOmopDest.getTableColumns()) {
            EtlTableColumn etlTableColumn = new EtlTableColumn();
            etlTableColumn.setTableName(tableColumn.getTableName());
            etlTableColumn.setColumnName(tableColumn.getColumnName());
            etlTableColumn.setPath(tableColumn.getPath());
            etlTableColumn.setFormat(tableColumn.getFormat());
            etlTableColumns.add(etlTableColumn);
        }
        this.visitCommon((Destination)omopDestination, (EtlDestination)etlOmopDest);
        this.etlDestination = etlOmopDest;
    }

    public void visit(CovidOmopDestination covidOmopDestination) {
        EtlCovidOmopDestination etlCovidOmopDest = new EtlCovidOmopDestination();
        ArrayList<EtlTableColumn> etlTableColumns = new ArrayList<EtlTableColumn>();
        for (EtlTableColumn tableColumn : etlCovidOmopDest.getTableColumns()) {
            EtlTableColumn etlTableColumn = new EtlTableColumn();
            etlTableColumn.setTableName(tableColumn.getTableName());
            etlTableColumn.setColumnName(tableColumn.getColumnName());
            etlTableColumn.setPath(tableColumn.getPath());
            etlTableColumn.setFormat(tableColumn.getFormat());
            etlTableColumns.add(etlTableColumn);
        }
        this.visitCommon((Destination)covidOmopDestination, (EtlDestination)etlCovidOmopDest);
        this.etlDestination = etlCovidOmopDest;
    }

    public void visit(PhenotypeSearchDestination phenotypeSearchDestination) {
        EtlPhenotypeSearchDestination etlPhenotypeSearchDestination = new EtlPhenotypeSearchDestination();
        this.visitCommon((Destination)phenotypeSearchDestination, (EtlDestination)etlPhenotypeSearchDestination);
        this.etlDestination = etlPhenotypeSearchDestination;
    }
}

