/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PhenotypeConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdGroupEntity;
import java.util.List;
import org.protempa.ContextDefinition;
import org.protempa.ContextOffset;
import org.protempa.GapFunction;
import org.protempa.PropertyConstraint;
import org.protempa.SimpleGapFunction;
import org.protempa.TemporalExtendedParameterDefinition;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.AbsoluteTimeUnit;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

/*
 * Exception performing whole class analysis ignored.
 */
class ConversionUtil {
    static final String PRIMARY_PROP_ID_SUFFIX = "_PRIMARY";
    static final String VALUE = "YES";
    static final String VALUE_COMP = "NO";
    static final String PROP_ID_WRAPPED_SUFFIX = "_WRAPPED";
    static final String USER_KEY_PREFIX = "USER:";
    private static final PhenotypeConversionSupport CONVERSION_SUPPORT = new PhenotypeConversionSupport();

    ConversionUtil() {
    }

    static AbsoluteTimeUnit unit(TimeUnit unit) {
        return unit != null ? AbsoluteTimeUnit.nameToUnit((String)unit.getName()) : null;
    }

    static TemporalExtendedPropositionDefinition buildExtendedPropositionDefinition(ExtendedPhenotype ep) {
        PhenotypeEntity phenotypeEntity = ep.getPhenotypeEntity();
        TemporalExtendedPropositionDefinition tepd = ConversionUtil.buildExtendedPropositionDefinition((PhenotypeEntity)phenotypeEntity);
        if (ep.getPropertyConstraint() != null) {
            PropertyConstraint pc = new PropertyConstraint();
            pc.setPropertyName(ep.getPropertyConstraint().getPropertyName());
            pc.setValue(ValueType.VALUE.parse(ep.getPropertyConstraint().getValue()));
            pc.setValueComp(ValueComparator.EQUAL_TO);
            tepd.setPropertyConstraints(new PropertyConstraint[]{pc});
        }
        tepd.setMinLength(ep.getMinDuration());
        tepd.setMinLengthUnit((Unit)ConversionUtil.unit((TimeUnit)ep.getMinDurationTimeUnit()));
        tepd.setMaxLength(ep.getMaxDuration());
        tepd.setMaxLengthUnit((Unit)ConversionUtil.unit((TimeUnit)ep.getMaxDurationTimeUnit()));
        return tepd;
    }

    static ContextDefinition extractContextDefinition(ValueThresholdGroupEntity entity, List<ExtendedPhenotype> extendedPhenotypes, ValueThresholdEntity v) {
        ContextDefinition cd = new ContextDefinition(entity.getKey() + "_SUB_CONTEXT");
        cd.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
        TemporalExtendedPropositionDefinition[] tepds = new TemporalExtendedPropositionDefinition[extendedPhenotypes.size()];
        int i = 0;
        for (ExtendedPhenotype ede : extendedPhenotypes) {
            TemporalExtendedPropositionDefinition tepd;
            PhenotypeEntity dee = ede.getPhenotypeEntity();
            String tepdId = dee.getKey();
            if (!dee.isInSystem()) {
                tepdId = CONVERSION_SUPPORT.toPropositionId(tepdId);
            }
            if (dee instanceof ValueThresholdGroupEntity) {
                TemporalExtendedParameterDefinition teParamD = new TemporalExtendedParameterDefinition(tepdId);
                teParamD.setValue((Value)CONVERSION_SUPPORT.asValue(dee));
                tepd = teParamD;
            } else {
                tepd = new TemporalExtendedPropositionDefinition(tepdId);
            }
            tepd.setDisplayName(dee.getDisplayName());
            tepd.setMaxLength(ede.getMaxDuration());
            tepd.setMaxLengthUnit((Unit)ConversionUtil.unit((TimeUnit)ede.getMaxDurationTimeUnit()));
            tepd.setMinLength(ede.getMinDuration());
            tepd.setMinLengthUnit((Unit)ConversionUtil.unit((TimeUnit)ede.getMinDurationTimeUnit()));
            tepds[i++] = tepd;
        }
        cd.setInducedBy(tepds);
        ContextOffset offset = new ContextOffset();
        RelationOperator relOp = v.getRelationOperator();
        Integer withinAtLeast = v.getWithinAtLeast();
        Integer withinAtMost = v.getWithinAtMost();
        String relOpName = relOp.getName();
        if ("before".equals(relOpName)) {
            offset.setStartIntervalSide(Interval.Side.FINISH);
            offset.setFinishIntervalSide(Interval.Side.FINISH);
            if (withinAtLeast != null) {
                offset.setStartOffset(withinAtLeast);
            }
            offset.setStartOffsetUnits((Unit)ConversionUtil.unit((TimeUnit)v.getWithinAtLeastUnits()));
            offset.setFinishOffset(withinAtMost);
            offset.setFinishOffsetUnits((Unit)ConversionUtil.unit((TimeUnit)v.getWithinAtMostUnits()));
        } else if ("after".equals(relOpName)) {
            offset.setStartIntervalSide(Interval.Side.START);
            offset.setFinishIntervalSide(Interval.Side.START);
            offset.setStartOffset(withinAtMost != null ? Integer.valueOf(-withinAtMost.intValue()) : null);
            offset.setStartOffsetUnits((Unit)ConversionUtil.unit((TimeUnit)v.getWithinAtMostUnits()));
            if (withinAtLeast != null) {
                offset.setFinishOffset(Integer.valueOf(-withinAtLeast.intValue()));
            }
            offset.setFinishOffsetUnits((Unit)ConversionUtil.unit((TimeUnit)v.getWithinAtLeastUnits()));
        } else if ("around".equals(relOpName)) {
            offset.setStartIntervalSide(Interval.Side.START);
            offset.setFinishIntervalSide(Interval.Side.FINISH);
            offset.setStartOffset(withinAtLeast != null ? Integer.valueOf(-withinAtLeast.intValue()) : null);
            offset.setStartOffsetUnits((Unit)ConversionUtil.unit((TimeUnit)v.getWithinAtLeastUnits()));
            offset.setFinishOffset(withinAtMost);
            offset.setFinishOffsetUnits((Unit)ConversionUtil.unit((TimeUnit)v.getWithinAtMostUnits()));
        }
        cd.setOffset(offset);
        return cd;
    }

    private static TemporalExtendedPropositionDefinition buildExtendedPropositionDefinition(String propId, PhenotypeEntity entity) {
        TemporalExtendedPropositionDefinition tepd;
        if (entity instanceof ValueThresholdGroupEntity) {
            TemporalExtendedParameterDefinition tepvDef = new TemporalExtendedParameterDefinition(propId);
            tepvDef.setValue((Value)CONVERSION_SUPPORT.asValue(entity));
            tepd = tepvDef;
        } else {
            tepd = new TemporalExtendedPropositionDefinition(propId);
        }
        return tepd;
    }

    private static TemporalExtendedPropositionDefinition buildExtendedPropositionDefinition(PhenotypeEntity phenotypeEntity) {
        String propId = phenotypeEntity.isInSystem() ? phenotypeEntity.getKey() : CONVERSION_SUPPORT.toPropositionId(phenotypeEntity);
        return ConversionUtil.buildExtendedPropositionDefinition((String)propId, (PhenotypeEntity)phenotypeEntity);
    }
}

