/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.entity;

import edu.emory.cci.aiw.cvrg.eureka.services.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SequenceEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SystemProposition;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdGroupEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PropositionChildrenVisitor
implements PhenotypeEntityVisitor {
    private List<? extends PhenotypeEntity> children;

    public List<? extends PhenotypeEntity> getChildren() {
        return this.children;
    }

    public void visit(SystemProposition proposition) {
        this.children = new ArrayList();
    }

    public void visit(CategoryEntity categorization) {
        this.children = categorization.getMembers();
    }

    public void visit(SequenceEntity highLevelAbstraction) {
        this.children = highLevelAbstraction.getAbstractedFrom();
    }

    public void visit(ValueThresholdGroupEntity lowLevelAbstraction) {
        ArrayList<PhenotypeEntity> cs = new ArrayList<PhenotypeEntity>();
        for (ValueThresholdEntity v : lowLevelAbstraction.getValueThresholds()) {
            cs.add(v.getAbstractedFrom());
        }
        this.children = cs;
    }

    public void visit(FrequencyEntity sliceAbstraction) {
        this.children = Collections.singletonList(sliceAbstraction.getAbstractedFrom());
    }
}

