/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.config;

import edu.emory.cci.aiw.cvrg.eureka.services.comm.AppProperties;
import edu.emory.cci.aiw.cvrg.eureka.services.comm.AppPropertiesLinks;
import edu.emory.cci.aiw.cvrg.eureka.services.comm.AppPropertiesModes;
import edu.emory.cci.aiw.cvrg.eureka.services.comm.AppPropertiesRegistration;
import edu.emory.cci.aiw.cvrg.eureka.services.props.PublicUrlGenerator;
import edu.emory.cci.aiw.cvrg.eureka.services.props.SupportUri;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.eurekaclinical.standardapis.props.CasJerseyEurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServiceProperties
extends CasJerseyEurekaClinicalProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProperties.class);
    private AppPropertiesModes appPropertiesModes;
    private AppPropertiesLinks appPropertiesLinks;
    private AppPropertiesRegistration appPropertiesRegistration;
    private AppProperties appProperties;

    public ServiceProperties() {
        super("/etc/eureka");
    }

    public AppPropertiesModes getAppPropertiesModes() {
        this.appPropertiesModes = new AppPropertiesModes();
        this.appPropertiesModes.setDemoMode(Boolean.parseBoolean(this.getValue("eureka.common.demomode")));
        this.appPropertiesModes.setEphiProhibited(Boolean.parseBoolean(this.getValue("eureka.common.ephiprohibited")));
        return this.appPropertiesModes;
    }

    public AppPropertiesLinks getAppPropertiesLinks() {
        this.appPropertiesLinks = new AppPropertiesLinks();
        this.appPropertiesLinks.setSupportUri(this.getSupportUri());
        this.appPropertiesLinks.setOrganizationName(this.getValue("project.organization.name"));
        return this.appPropertiesLinks;
    }

    public AppPropertiesRegistration getAppPropertiesRegistration() {
        this.appPropertiesRegistration = new AppPropertiesRegistration();
        this.appPropertiesRegistration.setRegistrationEnabled(Boolean.parseBoolean(this.getValue("eureka.webapp.registrationenabled")));
        return this.appPropertiesRegistration;
    }

    public AppProperties getAppProperties() {
        this.appProperties = new AppProperties();
        this.appProperties.setAppPropertiesModes(this.getAppPropertiesModes());
        this.appProperties.setAppPropertiesLinks(this.getAppPropertiesLinks());
        this.appProperties.setAppPropertiesRegistration(this.getAppPropertiesRegistration());
        return this.appProperties;
    }

    public SupportUri getSupportUri() {
        SupportUri supportUri = null;
        try {
            String uriStr = this.getValue("eureka.support.uri");
            String uriName = this.getValue("eureka.support.uri.name");
            if (uriStr != null) {
                supportUri = new SupportUri(new URI(uriStr), uriName);
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Invalid support URI in application.properties", (Throwable)ex);
        }
        return supportUri;
    }

    public List<String> getDefaultSystemPropositions() {
        return this.getStringListValue("eureka.services.defaultprops", new ArrayList());
    }

    public void setAppPropertiesModes(AppPropertiesModes inAppPropertiesModes) {
        this.appPropertiesModes = inAppPropertiesModes;
    }

    public void setAppPropertiesLinks(AppPropertiesLinks inAppPropertiesLinks) {
        this.appPropertiesLinks = inAppPropertiesLinks;
    }

    public void setAppPropertiesRegistration(AppPropertiesRegistration inAppPropertiesRegistration) {
        this.appPropertiesRegistration = inAppPropertiesRegistration;
    }

    public String getEtlUrl() {
        return this.getValue("eureka.etl.url");
    }

    public String getServicesUrl(HttpServletRequest request) {
        String servicesUrl = this.getValue("eureka.services.url");
        if (servicesUrl == null) {
            servicesUrl = PublicUrlGenerator.generate((HttpServletRequest)request);
            servicesUrl = servicesUrl + (servicesUrl.endsWith("/") ? "" : "/") + "eureka-services";
        }
        return servicesUrl;
    }

    public String getProxyCallbackServer() {
        return this.getValue("eureka.services.callbackserver");
    }

    public String getUrl() {
        return this.getValue("eureka.services.url");
    }
}

