/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.AuthorizedRoleEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.UserTemplateEntity;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.resource.AbstractUserTemplateResource;
import org.eurekaclinical.eureka.client.comm.AnalyticsUserTemplate;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;

@Path(value="/protected/usertemplates")
@Transactional
public class UserTemplateResource
extends AbstractUserTemplateResource<AnalyticsUserTemplate, AuthorizedRoleEntity, UserTemplateEntity> {
    private final RoleDao<AuthorizedRoleEntity> roleDao;

    @Inject
    public UserTemplateResource(UserTemplateDao<AuthorizedRoleEntity, UserTemplateEntity> inUserDao, RoleDao<AuthorizedRoleEntity> inRoleDao) {
        super(inUserDao);
        this.roleDao = inRoleDao;
    }

    protected AnalyticsUserTemplate toComm(UserTemplateEntity templateEntity, HttpServletRequest req) {
        AnalyticsUserTemplate template = new AnalyticsUserTemplate();
        template.setId(templateEntity.getId());
        template.setName(templateEntity.getName());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (AuthorizedRoleEntity roleEntity : templateEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        template.setRoles(roles);
        template.setAutoAuthorize(templateEntity.isAutoAuthorize());
        template.setCriteria(templateEntity.getCriteria());
        return template;
    }

    protected UserTemplateEntity toEntity(AnalyticsUserTemplate template) {
        UserTemplateEntity templateEntity = new UserTemplateEntity();
        templateEntity.setId(template.getId());
        templateEntity.setName(template.getName());
        List roleEntities = this.roleDao.getAll();
        for (Long roleId : template.getRoles()) {
            for (AuthorizedRoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                templateEntity.addRole(roleEntity);
            }
        }
        templateEntity.setAutoAuthorize(template.isAutoAuthorize());
        templateEntity.setCriteria(template.getCriteria());
        return templateEntity;
    }
}

