/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.finder;

import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.PropositionFindException;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.PropositionRetriever;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.protempa.client.EurekaClinicalProtempaClient;
import org.protempa.PropositionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropositionRetriever
implements PropositionRetriever<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropositionRetriever.class);
    private final EurekaClinicalProtempaClient etlClient;

    @Inject
    public SystemPropositionRetriever(EurekaClinicalProtempaClient inEtlClient) {
        this.etlClient = inEtlClient;
    }

    public PropositionDefinition retrieve(String sourceConfigId, String inKey) throws PropositionFindException {
        PropositionDefinition result;
        try {
            result = this.etlClient.getPropositionDefinition(sourceConfigId, inKey);
        }
        catch (ClientException e) {
            ClientResponse.Status status = e.getResponseStatus();
            if (status == ClientResponse.Status.NOT_FOUND) {
                result = null;
            }
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new PropositionFindException("Could not retrieve proposition definition " + inKey, (Throwable)e);
        }
        return result;
    }

    public List<PropositionDefinition> retrieveAll(String sourceConfigId, List<String> inKeys, Boolean withChildren) throws PropositionFindException {
        ArrayList<PropositionDefinition> result;
        block2: {
            result = new ArrayList();
            try {
                result = this.etlClient.getPropositionDefinitions(sourceConfigId, inKeys, withChildren);
            }
            catch (ClientException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                ClientResponse.Status status = e.getResponseStatus();
                if (status == ClientResponse.Status.NOT_FOUND) break block2;
                throw new PropositionFindException("Could not retrieve proposition definitions " + StringUtils.join(inKeys, (String)", "), (Throwable)e);
            }
        }
        return result;
    }
}

