/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.RelationOperatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ThresholdsOperatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.TimeUnitDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ValueComparatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PropositionTypeVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ThresholdsOperator;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueComparator;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdGroupEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslatorUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.ValueThreshold;
import org.eurekaclinical.eureka.client.comm.ValueThresholds;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValueThresholdsTranslator
implements PropositionTranslator<ValueThresholds, ValueThresholdGroupEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueThresholdsTranslator.class);
    private final TranslatorSupport translatorSupport;
    private final ValueComparatorDao valueCompDao;
    private final ThresholdsOperatorDao thresholdsOperatorDao;
    private final TimeUnitDao timeUnitDao;
    private final RelationOperatorDao relationOpDao;

    @Inject
    public ValueThresholdsTranslator(ValueComparatorDao inValueComparatorDao, ThresholdsOperatorDao inThresholdsOperatorDao, TranslatorSupport inSupport, TimeUnitDao inTimeUnitDao, RelationOperatorDao inRelationOpDao) {
        this.valueCompDao = inValueComparatorDao;
        this.thresholdsOperatorDao = inThresholdsOperatorDao;
        this.translatorSupport = inSupport;
        this.timeUnitDao = inTimeUnitDao;
        this.relationOpDao = inRelationOpDao;
    }

    public ValueThresholdGroupEntity translateFromPhenotype(ValueThresholds phenotype) throws PhenotypeHandlingException {
        if (phenotype == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        ValueThresholdGroupEntity result = (ValueThresholdGroupEntity)this.translatorSupport.getUserEntityInstance((Phenotype)phenotype, ValueThresholdGroupEntity.class);
        result.setThresholdsOperator((ThresholdsOperator)this.thresholdsOperatorDao.retrieve((Object)phenotype.getThresholdsOperator()));
        ArrayList<ValueThresholdEntity> thresholds = result.getValueThresholds();
        if (thresholds == null) {
            thresholds = new ArrayList<ValueThresholdEntity>();
            result.setValueThresholds(thresholds);
        }
        int i = 0;
        for (ValueThreshold vt : phenotype.getValueThresholds()) {
            ValueThresholdEntity vte;
            if (thresholds.size() > i) {
                vte = (ValueThresholdEntity)thresholds.get(i);
            } else {
                vte = new ValueThresholdEntity();
                thresholds.add(vte);
            }
            vte.setAbstractedFrom(this.translatorSupport.getUserOrSystemEntityInstance(phenotype.getUserId(), vt.getPhenotype().getPhenotypeKey()));
            String lowerValue = vt.getLowerValue();
            vte.setMinTValueThreshold(lowerValue);
            if (lowerValue != null && !lowerValue.isEmpty()) {
                try {
                    vte.setMinValueThreshold(new BigDecimal(lowerValue));
                }
                catch (NumberFormatException ex) {
                    LOGGER.debug("Could not parse " + lowerValue + " as a BigDecimal", (Throwable)ex);
                }
            }
            vte.setMinValueComp((ValueComparator)this.valueCompDao.retrieve((Object)vt.getLowerComp()));
            String upperValue = vt.getUpperValue();
            vte.setMaxTValueThreshold(upperValue);
            if (upperValue != null && !upperValue.isEmpty()) {
                try {
                    vte.setMaxValueThreshold(new BigDecimal(upperValue));
                }
                catch (NumberFormatException ex) {
                    LOGGER.debug("Could not parse " + upperValue + " as a BigDecimal", (Throwable)ex);
                }
            }
            vte.setMaxValueComp((ValueComparator)this.valueCompDao.retrieve((Object)vt.getUpperComp()));
            ArrayList<ExtendedPhenotype> extendedPhenotypes = vte.getExtendedPhenotypes();
            vte.setRelationOperator((RelationOperator)this.relationOpDao.retrieve((Object)vt.getRelationOperator()));
            vte.setWithinAtLeast(vt.getWithinAtLeast());
            vte.setWithinAtLeastUnits((TimeUnit)this.timeUnitDao.retrieve((Object)vt.getWithinAtLeastUnit()));
            vte.setWithinAtMost(vt.getWithinAtMost());
            vte.setWithinAtMostUnits((TimeUnit)this.timeUnitDao.retrieve((Object)vt.getWithinAtMostUnit()));
            if (extendedPhenotypes == null) {
                extendedPhenotypes = new ArrayList<ExtendedPhenotype>();
                vte.setExtendedPhenotypes(extendedPhenotypes);
            }
            int j = 0;
            List relatedPhenotypes = vt.getRelatedPhenotypes();
            if (relatedPhenotypes != null) {
                for (PhenotypeField de : relatedPhenotypes) {
                    ExtendedPhenotype ede = null;
                    if (extendedPhenotypes.size() > j) {
                        ede = (ExtendedPhenotype)extendedPhenotypes.get(j);
                        PropositionTranslatorUtil.createOrUpdateExtendedProposition((ExtendedPhenotype)ede, (PhenotypeField)de, (Long)phenotype.getUserId(), (TimeUnitDao)this.timeUnitDao, (TranslatorSupport)this.translatorSupport, (ValueComparatorDao)this.valueCompDao);
                    } else {
                        extendedPhenotypes.add(PropositionTranslatorUtil.createOrUpdateExtendedProposition((ExtendedPhenotype)ede, (PhenotypeField)de, (Long)phenotype.getUserId(), (TimeUnitDao)this.timeUnitDao, (TranslatorSupport)this.translatorSupport, (ValueComparatorDao)this.valueCompDao));
                    }
                    ++j;
                }
            }
            for (int k = extendedPhenotypes.size() - 1; k >= j; --k) {
                extendedPhenotypes.remove(k);
            }
            ++i;
        }
        result.setValueThresholds(thresholds);
        return result;
    }

    public ValueThresholds translateFromProposition(ValueThresholdGroupEntity entity) {
        ValueThresholds result = new ValueThresholds();
        PropositionTranslatorUtil.populateCommonPhenotypeFields((Phenotype)result, (PhenotypeEntity)entity);
        result.setThresholdsOperator(entity.getThresholdsOperator().getId());
        ArrayList<ValueThreshold> thresholds = new ArrayList<ValueThreshold>();
        for (ValueThresholdEntity vte : entity.getValueThresholds()) {
            ValueThreshold threshold = new ValueThreshold();
            threshold.setLowerValue(vte.getMinTValueThreshold());
            threshold.setLowerComp(vte.getMinValueComp().getId());
            threshold.setUpperValue(vte.getMaxTValueThreshold());
            threshold.setUpperComp(vte.getMaxValueComp().getId());
            PhenotypeEntity phenotypeEntity = vte.getAbstractedFrom();
            PhenotypeField elementField = new PhenotypeField();
            PropositionTypeVisitor visitor = new PropositionTypeVisitor();
            phenotypeEntity.accept((PhenotypeEntityVisitor)visitor);
            elementField.setType(visitor.getType());
            elementField.setPhenotypeDescription(phenotypeEntity.getDescription());
            elementField.setPhenotypeDisplayName(phenotypeEntity.getDisplayName());
            elementField.setPhenotypeKey(phenotypeEntity.getKey());
            threshold.setPhenotype(elementField);
            ArrayList<PhenotypeField> relatedPhenotypes = new ArrayList<PhenotypeField>();
            for (ExtendedPhenotype elt : vte.getExtendedPhenotypes()) {
                PhenotypeField phenotypeField = PropositionTranslatorUtil.createPhenotypeField((ExtendedPhenotype)elt);
                relatedPhenotypes.add(phenotypeField);
            }
            threshold.setRelatedPhenotypes(relatedPhenotypes);
            threshold.setWithinAtLeast(vte.getWithinAtLeast());
            threshold.setWithinAtLeastUnit(vte.getWithinAtLeastUnits().getId());
            threshold.setWithinAtMost(vte.getWithinAtMost());
            threshold.setWithinAtMostUnit(vte.getWithinAtMostUnits().getId());
            threshold.setRelationOperator(vte.getRelationOperator().getId());
            thresholds.add(threshold);
        }
        result.setValueThresholds(thresholds);
        return result;
    }
}

