/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import edu.emory.cci.aiw.cvrg.eureka.services.dao.TimeUnitDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ValueComparatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PropertyConstraint;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PropositionTypeVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueComparator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import javax.ws.rs.core.Response;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;

/*
 * Exception performing whole class analysis ignored.
 */
class PropositionTranslatorUtil {
    static void populateExtendedProposition(ExtendedPhenotype ep, PhenotypeEntity proposition, PhenotypeField phenotype, TimeUnitDao timeUnitDao, ValueComparatorDao valCompDao) throws PhenotypeHandlingException {
        ep.setPhenotypeEntity(proposition);
        if (phenotype.getHasDuration() == Boolean.TRUE) {
            ep.setMinDuration(phenotype.getMinDuration());
            Long minDurationUnits = phenotype.getMinDurationUnits();
            if (minDurationUnits == null) {
                throw new PhenotypeHandlingException(Response.Status.BAD_REQUEST, "Min duration units must be specified");
            }
            ep.setMinDurationTimeUnit((TimeUnit)timeUnitDao.retrieve((Object)minDurationUnits));
            ep.setMaxDuration(phenotype.getMaxDuration());
            Long maxDurationUnits = phenotype.getMaxDurationUnits();
            if (maxDurationUnits == null) {
                throw new PhenotypeHandlingException(Response.Status.BAD_REQUEST, "Max duration units must be specified");
            }
            ep.setMaxDurationTimeUnit((TimeUnit)timeUnitDao.retrieve((Object)maxDurationUnits));
        } else {
            ep.setMinDuration(null);
            Long minDurationUnitsL = phenotype.getMinDurationUnits();
            TimeUnit minDurationUnits = minDurationUnitsL != null ? (TimeUnit)timeUnitDao.retrieve((Object)minDurationUnitsL) : timeUnitDao.getDefault();
            ep.setMinDurationTimeUnit(minDurationUnits);
            ep.setMaxDuration(null);
            Long maxDurationUnitsL = phenotype.getMaxDurationUnits();
            TimeUnit maxDurationUnits = maxDurationUnitsL != null ? (TimeUnit)timeUnitDao.retrieve((Object)maxDurationUnitsL) : timeUnitDao.getDefault();
            ep.setMaxDurationTimeUnit(maxDurationUnits);
        }
        if (phenotype.getHasPropertyConstraint() == Boolean.TRUE) {
            String propertyName = phenotype.getProperty();
            if (propertyName == null) {
                throw new PhenotypeHandlingException(Response.Status.BAD_REQUEST, "A property name must be specified");
            }
            PropertyConstraint pc = ep.getPropertyConstraint();
            if (pc == null) {
                pc = new PropertyConstraint();
            }
            pc.setPropertyName(propertyName);
            pc.setValue(phenotype.getPropertyValue());
            ValueComparator valComp = (ValueComparator)valCompDao.getByName("=");
            if (valComp == null) {
                throw new AssertionError((Object)"Invalid value comparator: =");
            }
            pc.setValueComparator(valComp);
            ep.setPropertyConstraint(pc);
        } else {
            ep.setPropertyConstraint(null);
        }
    }

    private PropositionTranslatorUtil() {
    }

    static void populateCommonPhenotypeFields(Phenotype phenotype, PhenotypeEntity proposition) {
        phenotype.setId(proposition.getId());
        phenotype.setKey(proposition.getKey());
        phenotype.setDisplayName(proposition.getDisplayName());
        phenotype.setDescription(proposition.getDescription());
        phenotype.setCreated(proposition.getCreated());
        phenotype.setLastModified(proposition.getLastModified());
        phenotype.setUserId(proposition.getUserId());
        phenotype.setInSystem(proposition.isInSystem());
    }

    static ExtendedPhenotype createOrUpdateExtendedProposition(ExtendedPhenotype origEP, PhenotypeField phenotype, Long userId, TimeUnitDao timeUnitDao, TranslatorSupport translatorSupport, ValueComparatorDao valCompDao) throws PhenotypeHandlingException {
        ExtendedPhenotype ep = origEP;
        if (ep == null) {
            ep = new ExtendedPhenotype();
        }
        PhenotypeEntity proposition = translatorSupport.getUserOrSystemEntityInstance(userId, phenotype.getPhenotypeKey());
        PropositionTranslatorUtil.populateExtendedProposition((ExtendedPhenotype)ep, (PhenotypeEntity)proposition, (PhenotypeField)phenotype, (TimeUnitDao)timeUnitDao, (ValueComparatorDao)valCompDao);
        return ep;
    }

    static PhenotypeField createPhenotypeField(ExtendedPhenotype ep) {
        PhenotypeField phenotype = new PhenotypeField();
        phenotype.setPhenotypeKey(ep.getPhenotypeEntity().getKey());
        phenotype.setPhenotypeDescription(ep.getPhenotypeEntity().getDescription());
        phenotype.setPhenotypeDisplayName(ep.getPhenotypeEntity().getDisplayName());
        PropositionTypeVisitor v = new PropositionTypeVisitor();
        ep.getPhenotypeEntity().accept((PhenotypeEntityVisitor)v);
        phenotype.setType(v.getType());
        if (ep.getMinDuration() != null) {
            phenotype.setHasDuration(Boolean.valueOf(true));
            phenotype.setMinDuration(ep.getMinDuration());
            phenotype.setMinDurationUnits(ep.getMinDurationTimeUnit().getId());
        }
        if (ep.getMaxDuration() != null) {
            phenotype.setHasDuration(Boolean.valueOf(true));
            phenotype.setMaxDuration(ep.getMaxDuration());
            phenotype.setMaxDurationUnits(ep.getMaxDurationTimeUnit().getId());
        }
        if (ep.getPropertyConstraint() != null) {
            phenotype.setHasPropertyConstraint(Boolean.valueOf(true));
            phenotype.setProperty(ep.getPropertyConstraint().getPropertyName());
            phenotype.setPropertyValue(ep.getPropertyConstraint().getValue());
        }
        return phenotype;
    }
}

