/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.FrequencyTypeDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.TimeUnitDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ValueComparatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyType;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.SourceConfigResource;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslatorUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import javax.ws.rs.core.Response;
import org.eurekaclinical.eureka.client.comm.Frequency;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;

public final class FrequencyTranslator
implements PropositionTranslator<Frequency, FrequencyEntity> {
    private final TimeUnitDao timeUnitDao;
    private final ValueComparatorDao valueComparatorDao;
    private final FrequencyTypeDao freqTypeDao;
    private final TranslatorSupport translatorSupport;

    @Inject
    public FrequencyTranslator(PhenotypeEntityDao inPropositionDao, TimeUnitDao inTimeUnitDao, SystemPropositionFinder inFinder, ValueComparatorDao inValueComparatorDao, FrequencyTypeDao inFrequencyTypeDao, SourceConfigResource inSourceConfigResource) {
        this.timeUnitDao = inTimeUnitDao;
        this.translatorSupport = new TranslatorSupport(inPropositionDao, inFinder, inSourceConfigResource);
        this.valueComparatorDao = inValueComparatorDao;
        this.freqTypeDao = inFrequencyTypeDao;
    }

    public FrequencyEntity translateFromPhenotype(Frequency phenotype) throws PhenotypeHandlingException {
        FrequencyEntity result = (FrequencyEntity)this.translatorSupport.getUserEntityInstance((Phenotype)phenotype, FrequencyEntity.class);
        result.setCount(phenotype.getAtLeast());
        result.setConsecutive(phenotype.getIsConsecutive().booleanValue());
        result.setExtendedProposition(PropositionTranslatorUtil.createOrUpdateExtendedProposition((ExtendedPhenotype)result.getExtendedProposition(), (PhenotypeField)phenotype.getPhenotype(), (Long)phenotype.getUserId(), (TimeUnitDao)this.timeUnitDao, (TranslatorSupport)this.translatorSupport, (ValueComparatorDao)this.valueComparatorDao));
        result.setInSystem(false);
        result.setFrequencyType((FrequencyType)this.freqTypeDao.retrieve((Object)phenotype.getFrequencyType()));
        if (phenotype.getIsWithin().booleanValue()) {
            result.setWithinAtLeast(phenotype.getWithinAtLeast());
            Long withinAtLeastUnitsL = phenotype.getWithinAtLeastUnits();
            if (withinAtLeastUnitsL == null) {
                throw new PhenotypeHandlingException(Response.Status.PRECONDITION_FAILED, "Within at least units must be specified");
            }
            result.setWithinAtLeastUnits((TimeUnit)this.timeUnitDao.retrieve((Object)withinAtLeastUnitsL));
            result.setWithinAtMost(phenotype.getWithinAtMost());
            Long withinAtMostUnitsL = phenotype.getWithinAtMostUnits();
            if (withinAtMostUnitsL == null) {
                throw new PhenotypeHandlingException(Response.Status.PRECONDITION_FAILED, "Within at most units must be specified");
            }
            result.setWithinAtMostUnits((TimeUnit)this.timeUnitDao.retrieve((Object)withinAtMostUnitsL));
        } else {
            result.setWithinAtLeast(null);
            Long withinAtLeastUnitsL = phenotype.getWithinAtLeastUnits();
            TimeUnit withinAtLeastUnits = withinAtLeastUnitsL != null ? (TimeUnit)this.timeUnitDao.retrieve((Object)withinAtLeastUnitsL) : this.timeUnitDao.getDefault();
            result.setWithinAtLeastUnits(withinAtLeastUnits);
            result.setWithinAtMost(null);
            Long withinAtMostUnitsL = phenotype.getWithinAtMostUnits();
            TimeUnit withinAtMostUnits = withinAtMostUnitsL != null ? (TimeUnit)this.timeUnitDao.retrieve((Object)withinAtMostUnitsL) : this.timeUnitDao.getDefault();
            result.setWithinAtMostUnits(withinAtMostUnits);
        }
        return result;
    }

    public Frequency translateFromProposition(FrequencyEntity entity) {
        Frequency result = new Frequency();
        PropositionTranslatorUtil.populateCommonPhenotypeFields((Phenotype)result, (PhenotypeEntity)entity);
        result.setAtLeast(entity.getCount());
        result.setIsConsecutive(Boolean.valueOf(entity.isConsecutive()));
        result.setPhenotype(PropositionTranslatorUtil.createPhenotypeField((ExtendedPhenotype)entity.getExtendedProposition()));
        result.setWithinAtLeast(entity.getWithinAtLeast());
        result.setWithinAtLeastUnits(entity.getWithinAtLeastUnits().getId());
        result.setWithinAtMost(entity.getWithinAtMost());
        result.setWithinAtMostUnits(entity.getWithinAtMostUnits().getId());
        result.setFrequencyType(entity.getFrequencyType().getId());
        if (result.getWithinAtLeast() != null || result.getWithinAtMost() != null) {
            result.setIsWithin(Boolean.valueOf(true));
        }
        return result;
    }
}

