/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.DestinationToEtlDestinationVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.EtlDestinationToDestinationVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.DestinationResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.eurekaclinical.eureka.client.comm.DestinationType;
import org.eurekaclinical.eureka.client.comm.DestinationVisitor;
import org.eurekaclinical.protempa.client.EurekaClinicalProtempaClient;
import org.eurekaclinical.protempa.client.comm.EtlDestination;
import org.eurekaclinical.protempa.client.comm.EtlDestinationVisitor;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Path(value="/protected/destinations")
@RolesAllowed(value={"researcher"})
@Consumes(value={"application/json"})
public class DestinationResource {
    private final EurekaClinicalProtempaClient protempaClient;
    private final ConversionSupport conversionSupport;

    @Inject
    public DestinationResource(EurekaClinicalProtempaClient inEtlClient, ConversionSupport inConversionSupport) {
        this.protempaClient = inEtlClient;
        this.conversionSupport = inConversionSupport;
    }

    @POST
    public Response create(@Context HttpServletRequest request, Destination inDestination) {
        Long destId;
        DestinationToEtlDestinationVisitor v = new DestinationToEtlDestinationVisitor(this.conversionSupport);
        inDestination.accept((DestinationVisitor)v);
        EtlDestination etlDest = v.getEtlDestination();
        try {
            destId = this.protempaClient.createDestination(etlDest);
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return Response.created((URI)URI.create("/" + destId)).build();
    }

    @PUT
    public void update(@Context HttpServletRequest request, Destination inDestination) {
        DestinationToEtlDestinationVisitor v = new DestinationToEtlDestinationVisitor(this.conversionSupport);
        inDestination.accept((DestinationVisitor)v);
        EtlDestination etlDest = v.getEtlDestination();
        try {
            this.protempaClient.updateDestination(etlDest);
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public List<Destination> getAll(@Context HttpServletRequest request, @QueryParam(value="type") DestinationType type) {
        try {
            List destinations;
            if (type == null) {
                destinations = this.protempaClient.getDestinations();
            } else {
                switch (1.$SwitchMap$org$eurekaclinical$eureka$client$comm$DestinationType[type.ordinal()]) {
                    case 1: {
                        destinations = this.protempaClient.getI2B2Destinations();
                        break;
                    }
                    case 2: {
                        destinations = this.protempaClient.getCohortDestinations();
                        break;
                    }
                    case 3: {
                        destinations = this.protempaClient.getPatientSetExtractorDestinations();
                        break;
                    }
                    case 4: {
                        destinations = this.protempaClient.getPatientSetSenderDestinations();
                        break;
                    }
                    case 5: {
                        destinations = this.protempaClient.getTabularFileDestinations();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected type " + type));
                    }
                }
            }
            ArrayList<Destination> result = new ArrayList<Destination>(destinations.size());
            EtlDestinationToDestinationVisitor v = new EtlDestinationToDestinationVisitor(this.conversionSupport);
            for (EtlDestination etlDest : destinations) {
                etlDest.accept((EtlDestinationVisitor)v);
                result.add(v.getDestination());
            }
            return result;
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Destination get(@Context HttpServletRequest request, @PathParam(value="id") String inId) {
        EtlDestinationToDestinationVisitor v = new EtlDestinationToDestinationVisitor(this.conversionSupport);
        try {
            this.protempaClient.getDestination(inId).accept((EtlDestinationVisitor)v);
        }
        catch (ClientException ex) {
            if (ex.getResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return v.getDestination();
    }

    @DELETE
    @Path(value="/{id}")
    public void delete(@PathParam(value="id") String inId) {
        try {
            this.protempaClient.deleteDestination(inId);
        }
        catch (ClientException ex) {
            if (ex.getResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }
}

