/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ValueComparatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueComparator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Transactional
@Path(value="/protected/valuecomps")
@Produces(value={"application/json"})
public class ValueComparatorResource {
    private ValueComparatorDao valueCompDao;

    @Inject
    public ValueComparatorResource(ValueComparatorDao valueCompDao) {
        this.valueCompDao = valueCompDao;
    }

    @GET
    public List<ValueComparator> getAllAsc() {
        return this.valueCompDao.getAllAsc();
    }

    @GET
    @Path(value="/{id}")
    public ValueComparator get(@PathParam(value="id") Long inId) {
        ValueComparator result = (ValueComparator)this.valueCompDao.retrieve((Object)inId);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND, "No value comparator with id " + inId);
        }
        return result;
    }

    @GET
    @Path(value="/byname/{name}")
    public ValueComparator getByName(@PathParam(value="name") String inName) {
        ValueComparator result = this.valueCompDao.getByName(inName);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND, "No value comparator with name " + inName);
        }
        return result;
    }
}

