/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.services.config.ServiceProperties;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionCollector;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.UserDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.UserEntity;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Job;
import org.eurekaclinical.eureka.client.comm.JobFilter;
import org.eurekaclinical.eureka.client.comm.JobSpec;
import org.eurekaclinical.eureka.client.comm.Statistics;
import org.eurekaclinical.protempa.client.EurekaClinicalProtempaClient;
import org.eurekaclinical.protempa.client.comm.JobRequest;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.protempa.PropositionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/protected/jobs")
@RolesAllowed(value={"researcher"})
public class JobResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobResource.class);
    private final UserDao userDao;
    private final PhenotypeEntityDao propositionDao;
    private final PropositionDefinitionConverterVisitor converterVisitor;
    private final EurekaClinicalProtempaClient etlClient;
    private final ConversionSupport conversionSupport;
    private final ServiceProperties properties;

    @Inject
    public JobResource(UserDao inUserDao, PropositionDefinitionConverterVisitor inVisitor, PhenotypeEntityDao inPropositionDao, EurekaClinicalProtempaClient inEtlClient, ServiceProperties inProperties) {
        this.userDao = inUserDao;
        this.propositionDao = inPropositionDao;
        this.converterVisitor = inVisitor;
        this.etlClient = inEtlClient;
        this.conversionSupport = new ConversionSupport();
        this.properties = inProperties;
    }

    @Transactional
    @POST
    @Consumes(value={"application/json"})
    public Response submit(@Context HttpServletRequest request, JobSpec jobSpec) {
        Long jobId;
        LOGGER.debug("Got job submission: {}", (Object)jobSpec);
        UserEntity user = (UserEntity)this.userDao.getByHttpServletRequest(request);
        JobRequest jobRequest = new JobRequest();
        PropositionDefinitionCollector collector = PropositionDefinitionCollector.getInstance((PropositionDefinitionConverterVisitor)this.converterVisitor, (List)this.propositionDao.getByUserId(user.getId()));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Sending {} proposition definitions:", (Object)collector.getUserPropDefs().size());
            for (PropositionDefinition pd : collector.getUserPropDefs()) {
                LOGGER.trace("PropDef: {}", (Object)pd);
            }
        }
        jobRequest.setJobSpec(jobSpec);
        jobRequest.setUserPropositions(collector.getUserPropDefs());
        List conceptIds = jobSpec.getPropositionIds();
        ArrayList<String> propIds = new ArrayList<String>(conceptIds != null ? conceptIds.size() : 0);
        if (conceptIds != null) {
            for (String conceptId : conceptIds) {
                propIds.add(this.conversionSupport.toPropositionId(conceptId));
            }
        }
        jobRequest.setPropositionIdsToShow(propIds);
        try {
            jobId = this.etlClient.submitJob(jobRequest);
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return Response.created((URI)URI.create("/" + jobId)).build();
    }

    @GET
    @Path(value="/{jobId}")
    @Produces(value={"application/json"})
    public Job getJob(@PathParam(value="jobId") Long inJobId) {
        try {
            return this.etlClient.getJob(inJobId);
        }
        catch (ClientException ex) {
            ClientResponse.Status responseStatus = ex.getResponseStatus();
            if (responseStatus == ClientResponse.Status.NOT_FOUND) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Path(value="/{jobId}/stats/{key}")
    @Produces(value={"application/json"})
    public Statistics getJobStats(@Context HttpServletRequest request, @PathParam(value="jobId") Long inJobId, @PathParam(value="key") String key) {
        try {
            Statistics stats = this.etlClient.getJobStats(inJobId, key != null ? this.conversionSupport.toPropositionId(key) : null);
            Statistics convertedStats = new Statistics();
            Map childrenToParents = stats.getChildrenToParents();
            HashMap<String, String> convertedChildrenToParents = new HashMap<String, String>();
            for (Map.Entry me : childrenToParents.entrySet()) {
                String phenotypeKey = this.conversionSupport.toPhenotypeKey((String)me.getKey());
                String parentKey = (String)me.getValue();
                if (phenotypeKey == null) continue;
                convertedChildrenToParents.put(phenotypeKey, parentKey != null ? this.conversionSupport.toPhenotypeKey(parentKey) : null);
            }
            convertedStats.setChildrenToParents(convertedChildrenToParents);
            Map counts = stats.getCounts();
            HashMap convertedCounts = new HashMap();
            for (Map.Entry me : counts.entrySet()) {
                String phenotypeKey = this.conversionSupport.toPhenotypeKey((String)me.getKey());
                if (phenotypeKey == null) continue;
                convertedCounts.put(phenotypeKey, me.getValue());
            }
            convertedStats.setCounts(convertedCounts);
            return convertedStats;
        }
        catch (ClientException ex) {
            ClientResponse.Status responseStatus = ex.getResponseStatus();
            if (responseStatus == ClientResponse.Status.NOT_FOUND) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Path(value="/{jobId}/stats")
    @Produces(value={"application/json"})
    public Statistics getJobStatsRoot(@Context HttpServletRequest request, @PathParam(value="jobId") Long inJobId) {
        return this.getJobStats(request, inJobId, null);
    }

    @GET
    @Produces(value={"application/json"})
    public List<Job> getJobsByUser(@QueryParam(value="order") String order) {
        try {
            if (order == null) {
                return this.etlClient.getJobs();
            }
            if (order.equals("desc")) {
                return this.etlClient.getJobsDesc();
            }
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Invalid value for the order query parameter: " + order);
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Path(value="/status")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json"})
    public List<Job> getStatus(@QueryParam(value="filter") JobFilter inFilter) {
        try {
            return this.etlClient.getJobStatus(inFilter);
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Path(value="/latest")
    @Produces(value={"application/json"})
    public List<Job> getLatestJob() {
        try {
            return this.etlClient.getLatestJob();
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }
}

