/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.PropositionFindException;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.SourceConfigResource;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.util.PropositionUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.SourceConfigParams;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.protempa.PropositionDefinition;

/*
 * Exception performing whole class analysis ignored.
 */
final class TranslatorSupport {
    private final SourceConfigResource sourceConfigResource;
    private final Map<PhenotypeMapKey, PhenotypeEntity> phenotypeEntities;
    private final PhenotypeEntityDao phenotypeEntityDao;
    private final SystemPropositionFinder finder;

    @Inject
    public TranslatorSupport(PhenotypeEntityDao phenotypeEntityDao, SystemPropositionFinder finder, SourceConfigResource inSourceConfigResource) {
        this.phenotypeEntityDao = phenotypeEntityDao;
        this.finder = finder;
        this.phenotypeEntities = new HashMap();
        this.sourceConfigResource = inSourceConfigResource;
    }

    PhenotypeEntity getUserOrSystemEntityInstance(Long userId, String key) throws PhenotypeHandlingException {
        PhenotypeEntity phenotypeEntity = this.phenotypeEntityDao.getUserOrSystemByUserAndKey(userId, key);
        if (phenotypeEntity == null) {
            List scps = this.sourceConfigResource.getParamsList();
            if (scps.isEmpty()) {
                throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
            }
            String sourceConfigId = ((SourceConfigParams)scps.get(0)).getId();
            PhenotypeMapKey deMapKey = new PhenotypeMapKey(userId, key);
            phenotypeEntity = (PhenotypeEntity)this.phenotypeEntities.get(deMapKey);
            if (phenotypeEntity == null) {
                try {
                    PropositionDefinition propDef = this.finder.find(sourceConfigId, (Object)key);
                    phenotypeEntity = PropositionUtil.toSystemProposition((PropositionDefinition)propDef, (Long)userId);
                    this.phenotypeEntities.put(deMapKey, phenotypeEntity);
                }
                catch (PropositionFindException ex) {
                    throw new PhenotypeHandlingException(Response.Status.PRECONDITION_FAILED, "No system phenotype with name " + key, (Throwable)ex);
                }
            }
        }
        return phenotypeEntity;
    }

    <P extends PhenotypeEntity> P getUserEntityInstance(Phenotype element, Class<P> cls) throws PhenotypeHandlingException {
        PhenotypeEntity result;
        String key = element.getKey() != null ? element.getKey() : "USER:" + element.getDisplayName();
        Date now = new Date();
        PhenotypeEntity oldEntity = null;
        if (element.getId() != null) {
            oldEntity = (PhenotypeEntity)this.phenotypeEntityDao.retrieve((Object)element.getId());
        }
        if (cls.isInstance(oldEntity)) {
            result = (PhenotypeEntity)cls.cast(oldEntity);
        } else {
            try {
                result = (PhenotypeEntity)cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new AssertionError((Object)("Could not instantiate entity " + key + ": " + ex.getMessage()));
            }
            result.setCreated(now);
        }
        result.setInSystem(false);
        result.setLastModified(now);
        TranslatorSupport.populateCommonEntityFields((PhenotypeEntity)result, (Phenotype)element);
        return (P)result;
    }

    private static void populateCommonEntityFields(PhenotypeEntity entity, Phenotype phenotype) {
        entity.setId(phenotype.getId());
        entity.setDisplayName(phenotype.getDisplayName());
        entity.setDescription(phenotype.getDescription());
        entity.setUserId(phenotype.getUserId());
        if (phenotype.getKey() != null) {
            entity.setKey(phenotype.getKey());
        } else {
            entity.setKey("USER:" + phenotype.getDisplayName());
        }
    }
}

