/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.util;

import edu.emory.cci.aiw.cvrg.eureka.services.entity.SystemProposition;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.PropositionFindException;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.util.PropositionDefinitionTypeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.arp.javautil.arrays.Arrays;
import org.eurekaclinical.eureka.client.comm.SystemPhenotype;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionVisitor;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PropositionUtil {
    private PropositionUtil() {
    }

    public static SystemProposition toSystemProposition(PropositionDefinition inDefinition, Long inUserId) {
        if (inDefinition == null) {
            throw new IllegalArgumentException("inDefinition cannot be null");
        }
        SystemProposition sysProp = new SystemProposition();
        sysProp.setKey(inDefinition.getId());
        sysProp.setInSystem(true);
        sysProp.setDisplayName(inDefinition.getDisplayName());
        sysProp.setDescription(inDefinition.getAbbreviatedDisplayName());
        sysProp.setUserId(inUserId);
        PropositionDefinitionTypeVisitor propDefTypeVisitor = new PropositionDefinitionTypeVisitor();
        inDefinition.accept((PropositionDefinitionVisitor)propDefTypeVisitor);
        sysProp.setSystemType(propDefTypeVisitor.getSystemType());
        return sysProp;
    }

    public static SystemPhenotype toSystemPhenotype(String sourceConfigId, PropositionDefinition inDefinition, boolean summarize, SystemPropositionFinder inPropositionFinder) throws PropositionFindException {
        if (inDefinition == null) {
            throw new IllegalArgumentException("inDefinition cannot be null");
        }
        SystemPhenotype systemPhenotype = new SystemPhenotype();
        systemPhenotype.setKey(inDefinition.getId());
        systemPhenotype.setInSystem(true);
        systemPhenotype.setInternalNode(inDefinition.getChildren().length > 0);
        systemPhenotype.setDescription(inDefinition.getAbbreviatedDisplayName());
        systemPhenotype.setDisplayName(inDefinition.getDisplayName());
        systemPhenotype.setSummarized(summarize);
        PropositionDefinitionTypeVisitor propDefTypeVisitor = new PropositionDefinitionTypeVisitor();
        inDefinition.accept((PropositionDefinitionVisitor)propDefTypeVisitor);
        systemPhenotype.setSystemType(propDefTypeVisitor.getSystemType());
        String[] inDefChildren = inDefinition.getChildren();
        systemPhenotype.setParent(inDefChildren.length > 0);
        ArrayList<String> properties = new ArrayList<String>();
        for (PropertyDefinition propertyDef : inDefinition.getPropertyDefinitions()) {
            properties.add(propertyDef.getId());
        }
        systemPhenotype.setProperties(properties);
        if (!summarize) {
            ArrayList<SystemPhenotype> children = new ArrayList<SystemPhenotype>();
            List pds = inPropositionFinder.findAll(sourceConfigId, Arrays.asList((Object[][])new String[][]{inDefChildren}), Boolean.FALSE);
            for (PropositionDefinition pd : pds) {
                children.add(PropositionUtil.toSystemPhenotype((String)sourceConfigId, (PropositionDefinition)pd, (boolean)true, (SystemPropositionFinder)inPropositionFinder));
            }
            systemPhenotype.setChildren(children);
        }
        return systemPhenotype;
    }
}

