/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SystemProposition;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.PropositionFindException;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.SourceConfigResource;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslatorUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.util.PropositionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.SourceConfigParams;
import org.eurekaclinical.eureka.client.comm.SystemPhenotype;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;

public class SystemPropositionTranslator
implements PropositionTranslator<SystemPhenotype, SystemProposition> {
    private final SystemPropositionFinder finder;
    private final SourceConfigResource sourceConfigResource;
    private final TranslatorSupport translatorSupport;

    @Inject
    public SystemPropositionTranslator(PhenotypeEntityDao inPropositionDao, SourceConfigResource inSourceConfigResource, SystemPropositionFinder inFinder) {
        this.finder = inFinder;
        this.sourceConfigResource = inSourceConfigResource;
        this.translatorSupport = new TranslatorSupport(inPropositionDao, inFinder, inSourceConfigResource);
    }

    public SystemProposition translateFromPhenotype(SystemPhenotype phenotype) throws PhenotypeHandlingException {
        SystemProposition proposition = (SystemProposition)this.translatorSupport.getUserEntityInstance((Phenotype)phenotype, SystemProposition.class);
        proposition.setSystemType(phenotype.getSystemType());
        return proposition;
    }

    public SystemPhenotype translateFromProposition(SystemProposition proposition) {
        SystemPhenotype phenotype = new SystemPhenotype();
        try {
            PropositionTranslatorUtil.populateCommonPhenotypeFields((Phenotype)phenotype, (PhenotypeEntity)proposition);
            List scps = this.sourceConfigResource.getParamsList();
            if (scps.isEmpty()) {
                throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
            }
            PropositionDefinition propDef = this.finder.find(((SourceConfigParams)scps.get(0)).getId(), (Object)proposition.getKey());
            ArrayList<SystemPhenotype> children = new ArrayList<SystemPhenotype>();
            for (String child : propDef.getInverseIsA()) {
                PropositionDefinition childDef = this.finder.find(((SourceConfigParams)scps.get(0)).getId(), (Object)child);
                SystemPhenotype childPhenotype = PropositionUtil.toSystemPhenotype((String)((SourceConfigParams)scps.get(0)).getId(), (PropositionDefinition)childDef, (boolean)true, (SystemPropositionFinder)this.finder);
                children.add(childPhenotype);
            }
            phenotype.setChildren(children);
            ArrayList<String> properties = new ArrayList<String>();
            for (PropertyDefinition property : propDef.getPropertyDefinitions()) {
                properties.add(property.getId());
            }
            phenotype.setProperties(properties);
            phenotype.setSystemType(proposition.getSystemType());
        }
        catch (PropositionFindException ex) {
            throw new AssertionError((Object)("Error getting proposition definitions: " + ex.getMessage()));
        }
        return phenotype;
    }
}

