/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.RelationOperatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.TimeUnitDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ValueComparatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PropositionTypeVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.Relation;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SequenceEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.SourceConfigResource;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslatorUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.RelatedPhenotypeField;
import org.eurekaclinical.eureka.client.comm.Sequence;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;

public class SequenceTranslator
implements PropositionTranslator<Sequence, SequenceEntity> {
    private Map<Long, ExtendedPhenotype> extendedProps;
    private final Map<String, PhenotypeEntity> propositions;
    private final TimeUnitDao timeUnitDao;
    private final RelationOperatorDao relationOperatorDao;
    private final TranslatorSupport translatorSupport;
    private final ValueComparatorDao valueComparatorDao;

    @Inject
    public SequenceTranslator(PhenotypeEntityDao inPropositionDao, TimeUnitDao inTimeUnitDao, RelationOperatorDao inRelationOperatorDao, SystemPropositionFinder inFinder, ValueComparatorDao inValueComparatorDao, SourceConfigResource inSourceConfigResource) {
        this.translatorSupport = new TranslatorSupport(inPropositionDao, inFinder, inSourceConfigResource);
        this.timeUnitDao = inTimeUnitDao;
        this.relationOperatorDao = inRelationOperatorDao;
        this.extendedProps = new HashMap();
        this.propositions = new HashMap();
        this.valueComparatorDao = inValueComparatorDao;
    }

    public SequenceEntity translateFromPhenotype(Sequence phenotype) throws PhenotypeHandlingException {
        if (phenotype == null) {
            throw new IllegalArgumentException("phenotype cannot be null");
        }
        Long userId = phenotype.getUserId();
        SequenceEntity result = (SequenceEntity)this.translatorSupport.getUserEntityInstance((Phenotype)phenotype, SequenceEntity.class);
        HashMap<String, PhenotypeField> phenotypesMap = new HashMap<String, PhenotypeField>();
        PhenotypeField primaryPhenotypeField = phenotype.getPrimaryPhenotype();
        ExtendedPhenotype ep = this.createExtendedProposition(result.getPrimaryExtendedPhenotype(), primaryPhenotypeField, Long.valueOf(1L), userId);
        phenotypesMap.put(primaryPhenotypeField.getPhenotypeKey(), primaryPhenotypeField);
        result.setPrimaryExtendedPhenotype(ep);
        ArrayList<Relation> relations = result.getRelations();
        if (relations == null) {
            relations = new ArrayList<Relation>();
            result.setRelations(relations);
        }
        int i = 0;
        for (RelatedPhenotypeField rde : phenotype.getRelatedPhenotypes()) {
            Relation relation;
            ExtendedPhenotype lhsEP = null;
            ExtendedPhenotype rhsEP = null;
            if (relations.size() > i) {
                relation = (Relation)relations.get(i);
                lhsEP = relation.getLhsExtendedPhenotype();
                rhsEP = relation.getRhsExtendedPhenotype();
            } else {
                relation = new Relation();
                relations.add(relation);
            }
            PhenotypeField lhsDEF = rde.getPhenotypeField();
            lhsEP = this.createExtendedProposition(lhsEP, rde.getPhenotypeField(), Long.valueOf(i + 2), userId);
            phenotypesMap.put(lhsDEF.getPhenotypeKey(), lhsDEF);
            PhenotypeField rhsDEF = (PhenotypeField)phenotypesMap.get(rde.getSequentialPhenotype());
            if (rhsDEF == null) {
                throw new PhenotypeHandlingException(Response.Status.PRECONDITION_FAILED, "Invalid phenotype " + rde.getSequentialPhenotype());
            }
            rhsEP = this.createExtendedProposition(rhsEP, rhsDEF, rde.getSequentialPhenotypeSource(), userId);
            RelationOperator relationOperator = (RelationOperator)this.relationOperatorDao.retrieve((Object)rde.getRelationOperator());
            relation.setMinf1s2(rde.getRelationMinCount());
            relation.setMinf1s2TimeUnit((TimeUnit)this.timeUnitDao.retrieve((Object)rde.getRelationMinUnits()));
            relation.setMaxf1s2(rde.getRelationMaxCount());
            relation.setMaxf1s2TimeUnit((TimeUnit)this.timeUnitDao.retrieve((Object)rde.getRelationMaxUnits()));
            relation.setRelationOperator(relationOperator);
            String relOpName = relationOperator.getName();
            if (relOpName.equals("before")) {
                relation.setLhsExtendedPhenotype(lhsEP);
                relation.setRhsExtendedPhenotype(rhsEP);
            } else if (relOpName.equals("after")) {
                relation.setLhsExtendedPhenotype(rhsEP);
                relation.setRhsExtendedPhenotype(lhsEP);
            } else {
                throw new PhenotypeHandlingException(Response.Status.BAD_REQUEST, "Invalid temporal relationship '" + relOpName + "'");
            }
            ++i;
        }
        return result;
    }

    private PhenotypeEntity getOrCreateProposition(Long userId, String key) throws PhenotypeHandlingException {
        PhenotypeEntity proposition = null;
        if (this.propositions.containsKey(key)) {
            proposition = (PhenotypeEntity)this.propositions.get(key);
        }
        if (proposition == null) {
            proposition = this.translatorSupport.getUserOrSystemEntityInstance(userId, key);
            this.propositions.put(proposition.getKey(), proposition);
        }
        return proposition;
    }

    private ExtendedPhenotype createExtendedProposition(ExtendedPhenotype origExtendedProposition, PhenotypeField phenotype, Long sequenceNumber, Long userId) throws PhenotypeHandlingException {
        ExtendedPhenotype result = (ExtendedPhenotype)this.extendedProps.get(sequenceNumber);
        if (result == null) {
            ExtendedPhenotype ep = origExtendedProposition;
            if (origExtendedProposition == null) {
                ep = new ExtendedPhenotype();
            }
            PhenotypeEntity proposition = this.getOrCreateProposition(userId, phenotype.getPhenotypeKey());
            PropositionTranslatorUtil.populateExtendedProposition((ExtendedPhenotype)ep, (PhenotypeEntity)proposition, (PhenotypeField)phenotype, (TimeUnitDao)this.timeUnitDao, (ValueComparatorDao)this.valueComparatorDao);
            this.extendedProps.put(sequenceNumber, ep);
            result = ep;
        }
        return result;
    }

    public Sequence translateFromProposition(SequenceEntity proposition) {
        Sequence result = new Sequence();
        PropositionTranslatorUtil.populateCommonPhenotypeFields((Phenotype)result, (PhenotypeEntity)proposition);
        if (proposition.getPrimaryExtendedPhenotype() != null) {
            result.setPrimaryPhenotype(this.createPhenotypeField(proposition.getPrimaryExtendedPhenotype()));
            List relations = proposition.getRelations();
            Long pId = proposition.getPrimaryExtendedPhenotype().getId();
            Map sequentialSources = this.assignSources(pId, proposition);
            ArrayList<RelatedPhenotypeField> relatedFields = new ArrayList<RelatedPhenotypeField>();
            for (Relation relation : relations) {
                RelatedPhenotypeField field = this.createRelatedPhenotypeField(relation);
                field.setSequentialPhenotypeSource((Long)sequentialSources.get(relation.getRhsExtendedPhenotype().getId()));
                relatedFields.add(field);
            }
            result.setRelatedPhenotypes(relatedFields);
        }
        return result;
    }

    private RelatedPhenotypeField createRelatedPhenotypeField(Relation relation) {
        RelatedPhenotypeField relatedPhenotype = new RelatedPhenotypeField();
        relatedPhenotype.setRelationMinCount(relation.getMinf1s2());
        relatedPhenotype.setRelationMinUnits(relation.getMinf1s2TimeUnit().getId());
        relatedPhenotype.setRelationMaxCount(relation.getMaxf1s2());
        relatedPhenotype.setRelationMaxUnits(relation.getMaxf1s2TimeUnit().getId());
        relatedPhenotype.setRelationOperator(relation.getRelationOperator().getId());
        if (relation.getRelationOperator().getName().equalsIgnoreCase("before")) {
            relatedPhenotype.setPhenotypeField(this.createPhenotypeField(relation.getLhsExtendedPhenotype()));
            relatedPhenotype.setSequentialPhenotype(relation.getRhsExtendedPhenotype().getPhenotypeEntity().getKey());
        } else if (relation.getRelationOperator().getName().equalsIgnoreCase("after")) {
            relatedPhenotype.setPhenotypeField(this.createPhenotypeField(relation.getRhsExtendedPhenotype()));
            relatedPhenotype.setSequentialPhenotype(relation.getLhsExtendedPhenotype().getPhenotypeEntity().getKey());
        }
        return relatedPhenotype;
    }

    private PhenotypeField createPhenotypeField(ExtendedPhenotype ep) {
        PhenotypeField phenotype = new PhenotypeField();
        PhenotypeEntity entity = ep.getPhenotypeEntity();
        PropositionTypeVisitor visitor = new PropositionTypeVisitor();
        entity.accept((PhenotypeEntityVisitor)visitor);
        phenotype.setType(visitor.getType());
        phenotype.setPhenotypeKey(entity.getKey());
        phenotype.setPhenotypeDescription(entity.getDescription());
        phenotype.setPhenotypeDisplayName(entity.getDisplayName());
        if (ep.getMinDuration() != null) {
            phenotype.setHasDuration(Boolean.valueOf(true));
            phenotype.setMinDuration(ep.getMinDuration());
            phenotype.setMinDurationUnits(ep.getMinDurationTimeUnit().getId());
        }
        if (ep.getMaxDuration() != null) {
            phenotype.setHasDuration(Boolean.valueOf(true));
            phenotype.setMaxDuration(ep.getMaxDuration());
            phenotype.setMaxDurationUnits(ep.getMaxDurationTimeUnit().getId());
        }
        if (ep.getPropertyConstraint() != null) {
            phenotype.setHasPropertyConstraint(Boolean.valueOf(true));
            phenotype.setProperty(ep.getPropertyConstraint().getPropertyName());
            phenotype.setPropertyValue(ep.getPropertyConstraint().getValue());
        }
        return phenotype;
    }

    private Map<Long, Long> assignSources(Long pId, SequenceEntity proposition) {
        HashMap<Long, Long> sequentialSources = new HashMap<Long, Long>();
        sequentialSources.put(pId, 1L);
        int i = 2;
        for (Relation relation : proposition.getRelations()) {
            Long epId = relation.getRhsExtendedPhenotype().getId();
            if (sequentialSources.containsKey(epId)) continue;
            sequentialSources.put(epId, Long.valueOf(i++));
        }
        return sequentialSources;
    }
}

