/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.CategorizationTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.FrequencyTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.SequenceTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.SystemPropositionTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.ValueThresholdsTranslator;
import org.eurekaclinical.eureka.client.comm.Category;
import org.eurekaclinical.eureka.client.comm.Frequency;
import org.eurekaclinical.eureka.client.comm.PhenotypeVisitor;
import org.eurekaclinical.eureka.client.comm.Sequence;
import org.eurekaclinical.eureka.client.comm.SystemPhenotype;
import org.eurekaclinical.eureka.client.comm.ValueThresholds;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;

public final class PhenotypeTranslatorVisitor
implements PhenotypeVisitor {
    private final SystemPropositionTranslator systemPropositionTranslator;
    private final SequenceTranslator sequenceTranslator;
    private final CategorizationTranslator categorizationTranslator;
    private final FrequencyTranslator frequencyTranslator;
    private final ValueThresholdsTranslator valueThresholdsTranslator;
    private PhenotypeEntity phenotypeEntity;

    @Inject
    public PhenotypeTranslatorVisitor(SystemPropositionTranslator inSystemPropositionTranslator, SequenceTranslator inSequenceTranslator, CategorizationTranslator inCategorizationTranslator, FrequencyTranslator inFrequencyTranslator, ValueThresholdsTranslator inValueThresholdsTranslator) {
        this.systemPropositionTranslator = inSystemPropositionTranslator;
        this.sequenceTranslator = inSequenceTranslator;
        this.categorizationTranslator = inCategorizationTranslator;
        this.frequencyTranslator = inFrequencyTranslator;
        this.valueThresholdsTranslator = inValueThresholdsTranslator;
    }

    public PhenotypeEntity getPhenotypeEntity() {
        return this.phenotypeEntity;
    }

    public void visit(SystemPhenotype systemElement) throws PhenotypeHandlingException {
        this.phenotypeEntity = this.systemPropositionTranslator.translateFromPhenotype(systemElement);
    }

    public void visit(Category categoricalPhenotype) throws PhenotypeHandlingException {
        this.phenotypeEntity = this.categorizationTranslator.translateFromPhenotype(categoricalPhenotype);
    }

    public void visit(Sequence sequence) throws PhenotypeHandlingException {
        this.phenotypeEntity = this.sequenceTranslator.translateFromPhenotype(sequence);
    }

    public void visit(Frequency frequency) throws PhenotypeHandlingException {
        this.phenotypeEntity = this.frequencyTranslator.translateFromPhenotype(frequency);
    }

    public void visit(ValueThresholds thresholds) throws PhenotypeHandlingException {
        this.phenotypeEntity = this.valueThresholdsTranslator.translateFromPhenotype(thresholds);
    }
}

