/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.TimeUnitDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Transactional
@Path(value="/protected/timeunits")
@Produces(value={"application/json"})
public class TimeUnitResource {
    private final TimeUnitDao timeUnitDao;

    @Inject
    public TimeUnitResource(TimeUnitDao inTimeUnitDao) {
        this.timeUnitDao = inTimeUnitDao;
    }

    @GET
    public List<TimeUnit> getAllAsc() {
        return this.timeUnitDao.getAllAsc();
    }

    @GET
    @Path(value="/{id}")
    public TimeUnit get(@PathParam(value="id") Long inId) {
        TimeUnit result = (TimeUnit)this.timeUnitDao.retrieve((Object)inId);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }

    @GET
    @Path(value="/byname/{name}")
    public TimeUnit getByName(@PathParam(value="name") String inName) {
        TimeUnit result = this.timeUnitDao.getByName(inName);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }
}

