/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.arp.javautil.string.StringUtil;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.FileSourceConfigOption;
import org.eurekaclinical.eureka.client.comm.SourceConfig;
import org.eurekaclinical.eureka.client.comm.SourceConfigOption;
import org.eurekaclinical.eureka.client.comm.SourceConfigParams;
import org.eurekaclinical.protempa.client.EurekaClinicalProtempaClient;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/protected/sourceconfig")
@RolesAllowed(value={"researcher"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SourceConfigResource {
    private final EurekaClinicalProtempaClient etlClient;

    @Inject
    public SourceConfigResource(EurekaClinicalProtempaClient inEtlClient) {
        this.etlClient = inEtlClient;
    }

    @GET
    public List<SourceConfig> getAll() {
        List sources;
        try {
            sources = this.etlClient.getSourceConfigs();
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return sources;
    }

    @GET
    @Path(value="/{id}")
    public SourceConfig get(@PathParam(value="id") String inId) {
        try {
            return this.etlClient.getSourceConfig(inId);
        }
        catch (ClientException ex) {
            if (ex.getResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    @GET
    @Path(value="/parameters/list")
    public List<SourceConfigParams> getParamsList() {
        ArrayList<SourceConfigParams> result = new ArrayList<SourceConfigParams>();
        try {
            for (SourceConfig config : this.etlClient.getSourceConfigs()) {
                result.add(SourceConfigResource.toParams((SourceConfig)config));
            }
        }
        catch (ClientException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return result;
    }

    @GET
    @Path(value="/parameters/{id}")
    public SourceConfigParams getParams(@PathParam(value="id") String inId) {
        try {
            return SourceConfigResource.toParams((SourceConfig)this.etlClient.getSourceConfig(inId));
        }
        catch (ClientException ex) {
            if (ex.getResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    private static SourceConfigParams toParams(SourceConfig config) {
        SourceConfigParams params = new SourceConfigParams();
        params.setId(config.getId());
        String displayName = config.getDisplayName();
        if (StringUtil.getEmptyOrNull((String)displayName)) {
            displayName = config.getId();
        }
        params.setName(displayName);
        ArrayList<SourceConfigParams.Upload> uploads = new ArrayList<SourceConfigParams.Upload>();
        for (SourceConfig.Section section : config.getDataSourceBackends()) {
            SourceConfigParams.Upload upload = null;
            String sourceId = null;
            String sampleUrl = null;
            for (SourceConfigOption option : section.getOptions()) {
                Object val;
                if (option instanceof FileSourceConfigOption) {
                    upload = new SourceConfigParams.Upload();
                    upload.setName(section.getDisplayName());
                    upload.setAcceptedMimetypes(((FileSourceConfigOption)option).getAcceptedMimetypes());
                    if (sourceId != null) {
                        upload.setSourceId(sourceId);
                    }
                    if (sampleUrl != null) {
                        upload.setSampleUrl(sampleUrl);
                    }
                    upload.setRequired(option.isRequired());
                    continue;
                }
                if (option.getName().equals("dataFileDirectoryName")) {
                    val = option.getValue();
                    if (val == null) continue;
                    sourceId = val.toString();
                    if (upload == null) continue;
                    upload.setSourceId(sourceId);
                    continue;
                }
                if (!option.getName().equals("sampleUrl") || (val = option.getValue()) == null) continue;
                sampleUrl = val.toString();
                if (upload == null) continue;
                upload.setSampleUrl(sampleUrl);
            }
            if (upload == null) continue;
            uploads.add(upload);
        }
        params.setUploads(uploads.toArray(new SourceConfigParams.Upload[uploads.size()]));
        return params;
    }
}

