/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.UserDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PropositionChildrenVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.UserEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PhenotypeEntityTranslatorVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PhenotypeTranslatorVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.SummarizingPhenotypeEntityTranslatorVisitor;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.PhenotypeVisitor;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
@Path(value="/protected/phenotypes")
@RolesAllowed(value={"researcher"})
@Consumes(value={"application/json"})
public class PhenotypeResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhenotypeResource.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("Messages");
    private final PhenotypeEntityDao phenotypeEntityDao;
    private final UserDao userDao;
    private final PhenotypeEntityTranslatorVisitor pETranslatorVisitor;
    private final PhenotypeTranslatorVisitor phenotypeTranslatorVisitor;
    private final SummarizingPhenotypeEntityTranslatorVisitor summpETranslatorVisitor;

    @Inject
    public PhenotypeResource(PhenotypeEntityDao inDao, UserDao inUserDao, PhenotypeEntityTranslatorVisitor inPETranslatorVisitor, SummarizingPhenotypeEntityTranslatorVisitor inSummpETranslatorVisitor, PhenotypeTranslatorVisitor inPhenotypeTranslatorVisitor) {
        this.phenotypeEntityDao = inDao;
        this.pETranslatorVisitor = inPETranslatorVisitor;
        this.summpETranslatorVisitor = inSummpETranslatorVisitor;
        this.phenotypeTranslatorVisitor = inPhenotypeTranslatorVisitor;
        this.userDao = inUserDao;
    }

    @GET
    @Produces(value={"application/json"})
    public List<Phenotype> getAll(@Context HttpServletRequest inRequest, @DefaultValue(value="false") @QueryParam(value="summarize") boolean inSummarize) {
        UserEntity user = (UserEntity)this.userDao.getByHttpServletRequest(inRequest);
        ArrayList<Phenotype> result = new ArrayList<Phenotype>();
        List phenotypeEntities = this.phenotypeEntityDao.getByUserId(user.getId());
        for (PhenotypeEntity phenotypeEntity : phenotypeEntities) {
            result.add(this.convertToPhenotype(phenotypeEntity, inSummarize));
        }
        return result;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Phenotype get(@Context HttpServletRequest inRequest, @PathParam(value="key") String inKey, @DefaultValue(value="false") @QueryParam(value="summarize") boolean inSummarize) {
        UserEntity user = (UserEntity)this.userDao.getByHttpServletRequest(inRequest);
        Phenotype result = this.readPhenotype(user, inKey, inSummarize);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }

    @POST
    public Response create(@Context HttpServletRequest request, Phenotype inPhenotype) {
        if (inPhenotype.getId() != null) {
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Phenotype to be created should not have an identifier.");
        }
        if (inPhenotype.getUserId() == null) {
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Phenotype to be created should have a user identifier.");
        }
        if (inPhenotype.isSummarized()) {
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Phenotype to be created cannot be summarized.");
        }
        try {
            inPhenotype.accept((PhenotypeVisitor)this.phenotypeTranslatorVisitor);
        }
        catch (PhenotypeHandlingException ex) {
            throw new HttpStatusException(ex.getStatus(), (Throwable)ex);
        }
        PhenotypeEntity phenotypeEntity = this.phenotypeTranslatorVisitor.getPhenotypeEntity();
        if (this.phenotypeEntityDao.getByUserAndKey(inPhenotype.getUserId(), phenotypeEntity.getKey()) != null) {
            String msg = messages.getString("phenotypeResource.create.error.duplicate");
            throw new HttpStatusException(Response.Status.CONFLICT, msg);
        }
        Date now = new Date();
        phenotypeEntity.setCreated(now);
        phenotypeEntity.setLastModified(now);
        this.phenotypeEntityDao.create((Object)phenotypeEntity);
        Long id = phenotypeEntity.getId();
        return Response.created((URI)URI.create("/" + id)).build();
    }

    @PUT
    @Path(value="/{id}")
    public void update(@Context HttpServletRequest inRequest, @PathParam(value="id") Long inId, Phenotype inElement) {
        if (inElement.getId() == null) {
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "The phenotype to be updated must have a unique identifier.");
        }
        if (inElement.getUserId() == null) {
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "The phenotype to be updated must have a user identifier");
        }
        if (inElement.isSummarized()) {
            throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Phenotype to be updated cannot be summarized.");
        }
        try {
            inElement.accept((PhenotypeVisitor)this.phenotypeTranslatorVisitor);
        }
        catch (PhenotypeHandlingException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        PhenotypeEntity phenotypeEntity = this.phenotypeTranslatorVisitor.getPhenotypeEntity();
        PhenotypeEntity potentialConflict = this.phenotypeEntityDao.getByUserAndKey(inElement.getUserId(), phenotypeEntity.getKey());
        if (potentialConflict != null && !potentialConflict.getId().equals(phenotypeEntity.getId())) {
            String msg = messages.getString("phenotypeResource.update.error.duplicate");
            throw new HttpStatusException(Response.Status.CONFLICT, msg);
        }
        PhenotypeEntity oldPhenotypeEntity = (PhenotypeEntity)this.phenotypeEntityDao.retrieve((Object)inElement.getId());
        if (oldPhenotypeEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        if (!oldPhenotypeEntity.getUserId().equals(inElement.getUserId())) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        UserEntity user = (UserEntity)this.userDao.getByHttpServletRequest(inRequest);
        if (!user.getId().equals(oldPhenotypeEntity.getUserId())) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        Date now = new Date();
        phenotypeEntity.setLastModified(now);
        phenotypeEntity.setCreated(oldPhenotypeEntity.getCreated());
        phenotypeEntity.setId(oldPhenotypeEntity.getId());
        this.phenotypeEntityDao.update((Object)phenotypeEntity);
    }

    @DELETE
    @Path(value="/{id}")
    public void delete(@PathParam(value="id") Long inId, @Context HttpServletRequest inRequest) {
        UserEntity user = (UserEntity)this.userDao.getByHttpServletRequest(inRequest);
        PhenotypeEntity phenotypeEntity = this.phenotypeEntityDao.getById(inId);
        if (phenotypeEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        List phenotypesUsedIn = this.getPhenotypesUsedIn(user.getId(), phenotypeEntity);
        if (!phenotypesUsedIn.isEmpty()) {
            this.deleteFailed(phenotypesUsedIn, phenotypeEntity);
        }
        this.phenotypeEntityDao.remove((Object)phenotypeEntity);
    }

    private void deleteFailed(List<String> phenotypesUsedIn, PhenotypeEntity proposition) throws HttpStatusException {
        String phenotypeList;
        int size = phenotypesUsedIn.size();
        if (size > 1) {
            List<String> subList = phenotypesUsedIn.subList(0, phenotypesUsedIn.size() - 1);
            phenotypeList = StringUtils.join(subList, (String)", ") + " and " + phenotypesUsedIn.get(size - 1);
        } else {
            phenotypeList = phenotypesUsedIn.get(0);
        }
        MessageFormat usedByOtherPhenotypes = new MessageFormat(messages.getString("phenotypeResource.delete.error.usedByOtherPhenotypes"));
        String msg = usedByOtherPhenotypes.format(new Object[]{proposition.getDisplayName(), phenotypesUsedIn.size(), phenotypeList});
        throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, msg);
    }

    private List<String> getPhenotypesUsedIn(Long inUserId, PhenotypeEntity proposition) {
        List others = this.phenotypeEntityDao.getByUserId(inUserId);
        ArrayList<String> phenotypesUsedIn = new ArrayList<String>();
        for (PhenotypeEntity other : others) {
            if (other.getId().equals(proposition.getId())) continue;
            PropositionChildrenVisitor visitor = new PropositionChildrenVisitor();
            other.accept((PhenotypeEntityVisitor)visitor);
            for (PhenotypeEntity child : visitor.getChildren()) {
                if (!child.getId().equals(proposition.getId())) continue;
                phenotypesUsedIn.add(other.getDisplayName());
            }
        }
        return phenotypesUsedIn;
    }

    private Phenotype readPhenotype(UserEntity userEntity, String inKey, boolean summarize) {
        PhenotypeEntity phenotypeEntity = this.phenotypeEntityDao.getByUserAndKey(userEntity.getId(), inKey);
        Phenotype result = this.convertToPhenotype(phenotypeEntity, summarize);
        return result;
    }

    private Phenotype convertToPhenotype(PhenotypeEntity phenotypeEntity, boolean summarize) {
        Phenotype result = null;
        if (phenotypeEntity != null) {
            result = summarize ? this.toSummarizedPhenotype(phenotypeEntity) : this.toPhenotype(phenotypeEntity);
        }
        return result;
    }

    private Phenotype toPhenotype(PhenotypeEntity phenotypeEntity) {
        phenotypeEntity.accept((PhenotypeEntityVisitor)this.pETranslatorVisitor);
        return this.pETranslatorVisitor.getPhenotype();
    }

    private Phenotype toSummarizedPhenotype(PhenotypeEntity phenotypeEntity) {
        phenotypeEntity.accept((PhenotypeEntityVisitor)this.summpETranslatorVisitor);
        return this.summpETranslatorVisitor.getPhenotype();
    }
}

