/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.entity;

import edu.emory.cci.aiw.cvrg.eureka.services.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyType;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@Entity
@Table(name="frequencies")
public class FrequencyEntity
extends PhenotypeEntity {
    @Column(nullable=false)
    private Integer count;
    private boolean consecutive;
    private Integer withinAtLeast;
    @ManyToOne
    @JoinColumn(referencedColumnName="id")
    private TimeUnit withinAtLeastUnits;
    private Integer withinAtMost;
    @ManyToOne
    @JoinColumn(referencedColumnName="id")
    private TimeUnit withinAtMostUnits;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(nullable=false)
    private ExtendedPhenotype extendedPhenotype;
    @ManyToOne
    @JoinColumn(nullable=false)
    private FrequencyType frequencyType;

    public FrequencyEntity() {
        super(CategoryEntity.CategoryType.SLICE_ABSTRACTION);
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean isConsecutive() {
        return this.consecutive;
    }

    public void setConsecutive(boolean consecutive) {
        this.consecutive = consecutive;
    }

    public PhenotypeEntity getAbstractedFrom() {
        return this.extendedPhenotype != null ? this.extendedPhenotype.getPhenotypeEntity() : null;
    }

    public ExtendedPhenotype getExtendedProposition() {
        return this.extendedPhenotype;
    }

    public void setExtendedProposition(ExtendedPhenotype extendedProposition) {
        this.extendedPhenotype = extendedProposition;
    }

    public Integer getWithinAtLeast() {
        return this.withinAtLeast;
    }

    public void setWithinAtLeast(Integer duration) {
        this.withinAtLeast = duration;
    }

    public TimeUnit getWithinAtLeastUnits() {
        return this.withinAtLeastUnits;
    }

    public void setWithinAtLeastUnits(TimeUnit withinAtLeastUnits) {
        this.withinAtLeastUnits = withinAtLeastUnits;
    }

    public Integer getWithinAtMost() {
        return this.withinAtMost;
    }

    public void setWithinAtMost(Integer duration) {
        this.withinAtMost = duration;
    }

    public TimeUnit getWithinAtMostUnits() {
        return this.withinAtMostUnits;
    }

    public void setWithinAtMostUnits(TimeUnit withinAtMostUnits) {
        this.withinAtMostUnits = withinAtMostUnits;
    }

    public FrequencyType getFrequencyType() {
        return this.frequencyType;
    }

    public void setFrequencyType(FrequencyType frequencyType) {
        this.frequencyType = frequencyType;
    }

    public void accept(PhenotypeEntityVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

