/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity_;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.eurekaclinical.standardapis.dao.GenericDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPhenotypeEntityDao
extends GenericDao<PhenotypeEntity, Long>
implements PhenotypeEntityDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaPhenotypeEntityDao.class);

    @Inject
    public JpaPhenotypeEntityDao(Provider<EntityManager> inProvider) {
        super(PhenotypeEntity.class, inProvider);
    }

    public PhenotypeEntity getByUserAndKey(Long inUserId, String inKey) {
        return this.getByUserAndKey(inUserId, inKey, true);
    }

    public PhenotypeEntity getUserOrSystemByUserAndKey(Long inUserId, String inKey) {
        return this.getByUserAndKey(inUserId, inKey, false);
    }

    public List<PhenotypeEntity> getByUserId(Long inUserId) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(PhenotypeEntity.class);
        Root root = criteriaQuery.from(PhenotypeEntity.class);
        Predicate userPredicate = builder.equal((Expression)root.get(PhenotypeEntity_.userId), (Object)inUserId);
        Predicate notInSystemPredicate = builder.equal((Expression)root.get(PhenotypeEntity_.inSystem), (Object)false);
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery.where((Expression)builder.and((Expression)userPredicate, (Expression)notInSystemPredicate)));
        return typedQuery.getResultList();
    }

    public PhenotypeEntity getById(Long inId) {
        PhenotypeEntity result = null;
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(PhenotypeEntity.class);
        Root root = criteriaQuery.from(PhenotypeEntity.class);
        Predicate idPredicate = builder.equal((Expression)root.get(PhenotypeEntity_.id), (Object)inId);
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery.where((Expression)builder.and(new Predicate[]{idPredicate})));
        result = (PhenotypeEntity)typedQuery.getSingleResult();
        return result;
    }

    private PhenotypeEntity getByUserAndKey(Long inUserId, String inKey, boolean excludeSystemElements) {
        PhenotypeEntity result = null;
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(PhenotypeEntity.class);
        Root root = criteriaQuery.from(PhenotypeEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(3);
        Predicate userPredicate = builder.equal((Expression)root.get(PhenotypeEntity_.userId), (Object)inUserId);
        predicates.add(userPredicate);
        Predicate keyPredicate = builder.equal((Expression)root.get(PhenotypeEntity_.key), (Object)inKey);
        predicates.add(keyPredicate);
        if (excludeSystemElements) {
            Predicate notInSystemPredicate = builder.equal((Expression)root.get(PhenotypeEntity_.inSystem), (Object)false);
            predicates.add(notInSystemPredicate);
        }
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery.where((Expression)builder.and(predicates.toArray(new Predicate[predicates.size()]))));
        try {
            result = (PhenotypeEntity)typedQuery.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            LOGGER.warn("Result not unique for user id = {} and key = {}", (Object)inUserId, (Object)inKey);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return result;
    }
}

