/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.AbstractValueThresholdGroupEntityConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdGroupEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.protempa.ContextDefinition;
import org.protempa.GapFunction;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.SlidingWindowWidthMode;

public final class ValueThresholdsLowLevelAbstractionConverter
extends AbstractValueThresholdGroupEntityConverter
implements PropositionDefinitionConverter<ValueThresholdGroupEntity, LowLevelAbstractionDefinition> {
    private PropositionDefinitionConverterVisitor converterVisitor;
    private LowLevelAbstractionDefinition primary;
    private String primaryPropId;

    public LowLevelAbstractionDefinition getPrimaryPropositionDefinition() {
        return this.primary;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropId;
    }

    public void setConverterVisitor(PropositionDefinitionConverterVisitor inVisitor) {
        this.converterVisitor = inVisitor;
    }

    public List<PropositionDefinition> convert(ValueThresholdGroupEntity entity) {
        if (entity.getValueThresholds().size() > 1) {
            throw new IllegalArgumentException("Low-level abstraction definitions may be created only from singleton value thresholds.");
        }
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        String propId = this.toPropositionId((PhenotypeEntity)entity);
        if (this.converterVisitor.addPropositionId(propId)) {
            LowLevelAbstractionDefinition wrapped = new LowLevelAbstractionDefinition(propId);
            wrapped.setDisplayName(entity.getDisplayName());
            wrapped.setDescription(entity.getDescription());
            wrapped.setAlgorithmId("stateDetector");
            if (entity.getValueThresholds() != null && entity.getValueThresholds().size() == 1) {
                ValueThresholdEntity threshold = (ValueThresholdEntity)entity.getValueThresholds().get(0);
                threshold.getAbstractedFrom().accept((PhenotypeEntityVisitor)this.converterVisitor);
                Collection abstractedFrom = this.converterVisitor.getPropositionDefinitions();
                wrapped.addPrimitiveParameterId(this.converterVisitor.getPrimaryPropositionId());
                this.thresholdToValueDefinitions(entity, threshold, wrapped);
                List extendedPhenotypes = threshold.getExtendedPhenotypes();
                if (extendedPhenotypes != null && !extendedPhenotypes.isEmpty()) {
                    ContextDefinition contextDefinition = ConversionUtil.extractContextDefinition((ValueThresholdGroupEntity)entity, (List)threshold.getExtendedPhenotypes(), (ValueThresholdEntity)threshold);
                    result.add((PropositionDefinition)contextDefinition);
                    wrapped.setContextId(contextDefinition.getId());
                }
                result.addAll(abstractedFrom);
            }
            wrapped.setSlidingWindowWidthMode(SlidingWindowWidthMode.DEFAULT);
            wrapped.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
            wrapped.setSourceId(this.sourceId((PhenotypeEntity)entity));
            result.add((PropositionDefinition)wrapped);
            this.primary = wrapped;
            this.primaryPropId = wrapped.getPropositionId();
        }
        return result;
    }
}

