package org.eurekaclinical.eureka.client.comm;

/*
 * #%L
 * Eureka Common
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 * @author Andrew Post
 */
public class Job {

    private Long id;
    /**
     * The initial timestamp when the job was started.
     */
    private Date startTimestamp;
    /**
     * The unique identifier of the configuration to use for this job.
     */
    private String sourceConfigId;
    /**
     * The unique identifier of the configuration to use for this job.
     */
    private String destinationId;
    private String username;
    private JobStatus status;
    private List<JobEvent> jobEvents;

    private List<Link> links;
    private boolean getStatisticsSupported;
    private Date finishTimeStamp;
    private JobMode jobMode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(Date timestamp) {
        this.startTimestamp = timestamp;
    }

    public String getSourceConfigId() {
        return sourceConfigId;
    }

    public void setSourceConfigId(String sourceConfigId) {
        this.sourceConfigId = sourceConfigId;
    }

    public String getDestinationId() {
        return destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public JobStatus getStatus() {
        return status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    /**
     * Gets job events, assumed in order of occurrence.
     *
     * @return a {@link List} of job events.
     */
    public List<JobEvent> getJobEvents() {
        return jobEvents;
    }

    /**
     * Sets job events, assumed in order of occurrence.
     *
     * @param jobEvents a {@link List} of job events.
     */
    public void setJobEvents(List<JobEvent> jobEvents) {
        this.jobEvents = jobEvents;
    }

    public List<Link> getLinks() {
        return links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean isGetStatisticsSupported() {
        return getStatisticsSupported;
    }

    public void setGetStatisticsSupported(boolean getStatisticsSupported) {
        this.getStatisticsSupported = getStatisticsSupported;
    }

    public Date getFinishTimestamp() {
        return finishTimeStamp;
    }

    public void setFinishTimestamp(Date timestamp) {
        this.finishTimeStamp = timestamp;
    }
    
    public void setJobMode(JobMode jobMode) {
        this.jobMode = jobMode;
    }
    
    public JobMode getJobMode() {
        return this.jobMode;
    }

    /**
     * Return a list of messages generated by the job.
     *
     * @return The list of messages.
     */
    public List<String> messages() {
        final List<String> messages = new ArrayList<>();
        for (JobEvent event : this.jobEvents) {
            final String message = event.getMessage();
            if (message != null) {
                messages.add(message);
            }
        }
        return messages;
    }

    public JobListRow toJobListRow() {
        JobListRow jobStatus = new JobListRow();
        jobStatus.setStatus(getStatus());
        jobStatus.setMessages(messages());
        jobStatus.setStartedDate(getStartTimestamp());

        jobStatus.setLinks(getLinks());
        jobStatus.setGetStatisticsSupported(isGetStatisticsSupported());
        jobStatus.setJobId(getId());

        jobStatus.setSourceConfigId(getSourceConfigId());
        jobStatus.setDestinationId(getDestinationId());
        jobStatus.setFinishedDate(getFinishTimestamp());
        return jobStatus;
    }

    @Override
    public String toString() {
        return "Job{" + "id=" + id + ", startTimestamp=" + startTimestamp + ", sourceConfigId=" + sourceConfigId + ", destinationId=" + destinationId + ", username=" + username + ", status=" + status + ", jobEvents=" + jobEvents + ", links=" + links + ", getStatisticsSupported=" + getStatisticsSupported + ", finishTimeStamp=" + finishTimeStamp + '}';
    }
    
}
