/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ConnectionSpecQueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.QuerySupport;
import edu.emory.cci.aiw.i2b2etl.ksb.ReadChildrenAction;
import edu.emory.cci.aiw.i2b2etl.ksb.ResultSetReader;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import edu.emory.cci.aiw.i2b2etl.ksb.UniqueIdTempTableHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.collections.Collections;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;

class LevelReader {
    private final QuerySupport querySupport;
    private final QueryConstructor READ_PARENTS_FROM_DB_QUERY_CONSTRUCTOR = new QueryConstructor(){

        @Override
        public void appendStatement(StringBuilder sql, String table) {
            sql.append("SELECT ").append(LevelReader.this.querySupport.getEurekaIdColumn()).append(" FROM ");
            sql.append(table);
            sql.append(" WHERE M_APPLIED_PATH='@' AND C_SYNONYM_CD='N' AND C_FULLNAME IN (SELECT C_PATH FROM ");
            sql.append(table);
            sql.append(" WHERE ").append(LevelReader.this.querySupport.getEurekaIdColumn()).append(" = ? AND M_APPLIED_PATH='@')");
        }
    };
    private static final ResultSetReader<Set<String>> RESULT_SET_READER = new ResultSetReader<Set<String>>(){

        @Override
        public Set<String> read(ResultSet rs) throws KnowledgeSourceReadException {
            try {
                HashSet<String> result = new HashSet<String>();
                if (rs != null) {
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                }
                return result;
            }
            catch (SQLException ex) {
                throw new KnowledgeSourceReadException((Throwable)ex);
            }
        }
    };
    private final QueryConstructor READ_CHILDREN_FROM_DB_QUERY_CONSTRUCTOR = new QueryConstructor(){

        @Override
        public void appendStatement(StringBuilder sql, String table) {
            sql.append("SELECT ").append(LevelReader.this.querySupport.getEurekaIdColumn()).append(" FROM ");
            sql.append(table);
            sql.append(" WHERE M_APPLIED_PATH='@' AND C_PATH=?");
        }
    };

    LevelReader(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    Set<String> readChildrenFromDatabase(String fullName, TableAccessReader tableAccessReader) throws KnowledgeSourceReadException {
        try (ConnectionSpecQueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(this.READ_CHILDREN_FROM_DB_QUERY_CONSTRUCTOR, tableAccessReader);){
            Set<String> set = queryExecutor.execute(fullName, RESULT_SET_READER);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readChildrenFromDatabase(Map<String, ? extends PropositionDefinition> propIdToPropDef, TableAccessReader tableAccessReader, ReadChildrenAction action) throws KnowledgeSourceReadException {
        if (propIdToPropDef != null && !propIdToPropDef.isEmpty()) {
            try (Connection connection = this.querySupport.getConnection();){
                try {
                    try (UniqueIdTempTableHandler childTempTableHandler = new UniqueIdTempTableHandler(this.querySupport.getDatabaseProduct(), connection, false);){
                        for (PropositionDefinition propositionDefinition : propIdToPropDef.values()) {
                            childTempTableHandler.insert(propositionDefinition.getId());
                        }
                    }
                    this.doReadChildren(connection, tableAccessReader, action, propIdToPropDef);
                    connection.commit();
                }
                catch (SQLException ex) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {}
                    finally {
                        throw ex;
                    }
                }
            }
            catch (SQLException | InvalidConnectionSpecArguments ex) {
                throw new KnowledgeSourceReadException(ex);
            }
        }
    }

    void readChildrenFromDatabase(Map<String, ? extends PropositionDefinition> propIdToPropDef, TableAccessReader tableAccessReader, ReadChildrenAction action, Connection connection) throws KnowledgeSourceReadException {
        if (propIdToPropDef != null && !propIdToPropDef.isEmpty()) {
            this.doReadChildren(connection, tableAccessReader, action, propIdToPropDef);
        }
    }

    private void doReadChildren(Connection connection, TableAccessReader tableAccessReader, ReadChildrenAction action, Map<String, ? extends PropositionDefinition> propIdToPropDef) throws KnowledgeSourceReadException {
        try (QueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(connection, (sql, table) -> {
            String ekIdCol = this.querySupport.getEurekaIdColumn();
            sql.append("SELECT A2.").append(ekIdCol).append(", A1.").append(ekIdCol).append(" FROM ");
            sql.append(table);
            sql.append(" A1 JOIN ");
            sql.append(table);
            sql.append(" A2 ON (A1.C_PATH=A2.C_FULLNAME) JOIN EK_TEMP_UNIQUE_IDS A3 ON (A3.UNIQUE_ID=A2.").append(ekIdCol).append(") WHERE A2.M_APPLIED_PATH='@' and A1.C_SYNONYM_CD='N' and A2.C_SYNONYM_CD='N'");
        }, tableAccessReader);){
            queryExecutor.execute(rs -> {
                HashMap result = new HashMap();
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            Collections.putSet(result, (Object)rs.getString(1), (Object)rs.getString(2));
                        }
                    }
                    catch (SQLException ex) {
                        throw new KnowledgeSourceReadException((Throwable)ex);
                    }
                    for (Map.Entry me : result.entrySet()) {
                        action.execute((PropositionDefinition)propIdToPropDef.get(me.getKey()), (Set)me.getValue());
                    }
                }
                return null;
            });
        }
    }

    Set<String> readParentsFromDatabase(String propId) throws KnowledgeSourceReadException {
        try (ConnectionSpecQueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstanceRestrictByEkUniqueIds(this.READ_PARENTS_FROM_DB_QUERY_CONSTRUCTOR, propId);){
            Set<String> set = queryExecutor.execute(propId, RESULT_SET_READER);
            return set;
        }
    }
}

