/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ConnectionSpecQueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.I2B2Util;
import edu.emory.cci.aiw.i2b2etl.ksb.ParameterSetter;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QuerySupport;
import edu.emory.cci.aiw.i2b2etl.ksb.ResultSetReader;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.Value;
import org.protempa.valueset.ValueSet;
import org.protempa.valueset.ValueSetElement;

class ConceptPropertyReader {
    private final QuerySupport querySupport;
    private final QueryConstructor READ_FROM_DB_QUERY_CONSTRUCTOR = new QueryConstructor(){

        @Override
        public void appendStatement(StringBuilder sql, String table) {
            sql.append("SELECT C_HLEVEL, C_FULLNAME FROM ");
            sql.append(table);
            sql.append(" WHERE ").append(ConceptPropertyReader.this.querySupport.getEurekaIdColumn()).append(" = ? AND M_APPLIED_PATH='@'");
        }
    };

    ConceptPropertyReader(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    ValueSet readFromDatabase(String id) throws KnowledgeSourceReadException {
        final TableAccessReader tableAccessReader = this.querySupport.getTableAccessReaderBuilder().restrictTablesBy(id).build();
        ResultSetReader<ValueSetElement[]> reader = new ResultSetReader<ValueSetElement[]>(){

            @Override
            public ValueSetElement[] read(ResultSet rs) throws KnowledgeSourceReadException {
                try {
                    if (rs != null && rs.next()) {
                        int c_hlevel = rs.getInt(1);
                        String fullName = rs.getString(2);
                        return ConceptPropertyReader.this.readLevelFromDatabaseHelper(c_hlevel, fullName, 1, tableAccessReader);
                    }
                    return null;
                }
                catch (SQLException ex) {
                    throw new KnowledgeSourceReadException((Throwable)ex);
                }
            }
        };
        try (ConnectionSpecQueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(this.READ_FROM_DB_QUERY_CONSTRUCTOR, tableAccessReader);){
            ValueSet valueSet = new ValueSet(id, null, queryExecutor.execute(id, reader), null);
            return valueSet;
        }
    }

    ValueSetElement[] readLevelFromDatabaseHelper(final int c_hlevel, final String fullName, final int offset, TableAccessReader tableAccessReader) throws KnowledgeSourceReadException {
        try (ConnectionSpecQueryExecutor queryExecutor = this.querySupport.getQueryExecutorInstance(new QueryConstructor(){

            @Override
            public void appendStatement(StringBuilder sql, String table) {
                sql.append("SELECT ").append(ConceptPropertyReader.this.querySupport.getEurekaIdColumn()).append(", C_NAME FROM ");
                sql.append(table);
                sql.append(" WHERE C_HLEVEL=? AND M_APPLIED_PATH='@' AND C_FULLNAME LIKE ? ESCAPE '\\'");
            }
        }, tableAccessReader);){
            ValueSetElement[] valueSetElementArray = queryExecutor.execute(new ParameterSetter(){
                private static final String ONT_PATH_SEP = "\\";
                private String newFullName;
                {
                    this.newFullName = this.newFullName(fullName, offset);
                }

                @Override
                public int set(PreparedStatement stmt, int j) throws SQLException {
                    stmt.setInt(j++, c_hlevel + offset);
                    stmt.setString(j++, this.newFullName + "%");
                    return j;
                }

                private String newFullName(String fullName3, int offset2) {
                    String fullName2 = fullName3;
                    if (fullName2.length() == 0) {
                        return fullName2;
                    }
                    if (fullName2.endsWith(ONT_PATH_SEP)) {
                        fullName2 = fullName2.substring(0, fullName2.length() - 1);
                    }
                    if (offset2 == -1) {
                        int lastIndexOf = fullName2.lastIndexOf(ONT_PATH_SEP);
                        fullName2 = lastIndexOf == -1 ? "" : fullName2.substring(0, lastIndexOf);
                    }
                    fullName2 = I2B2Util.escapeLike(fullName2);
                    return fullName2;
                }
            }, new ResultSetReader<ValueSetElement[]>(){

                @Override
                public ValueSetElement[] read(ResultSet rs) throws KnowledgeSourceReadException {
                    ArrayList<ValueSetElement> result = new ArrayList<ValueSetElement>();
                    if (rs != null) {
                        try {
                            while (rs.next()) {
                                result.add(new ValueSetElement((Value)NominalValue.getInstance((String)rs.getString(1)), rs.getString(2), null));
                            }
                        }
                        catch (SQLException ex) {
                            throw new KnowledgeSourceReadException((Throwable)ex);
                        }
                    }
                    return result.toArray(new ValueSetElement[result.size()]);
                }
            });
            return valueSetElementArray;
        }
    }
}

